package cn.webestar.scms.commons.api;

import cn.webestar.scms.commons.entity.Entity;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

public abstract class LimitBody extends Body{

    private Integer offset = 0;
    private Integer limit = 100;

    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    /**
     * 转换成查询参数
     * @param <T> 查询参数格式对象
     * @return 查询参数
     */
    public <T extends Entity> Wrapper<T> toWapper() {
        LambdaQueryWrapper<T> queryWrapper = toQueryWapper();
        queryWrapper.last("limit " + getOffset() + "," + getLimit());
        return queryWrapper;
    }

//    public abstract <T> QueryWrapper<T> toParamsQueryWapper();

    public abstract <T extends Entity> LambdaQueryWrapper<T> toQueryWapper();

}
