package cn.webestar.scms.commons.api;

import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.Collections;
import java.util.List;

public class PageVO<T> {

    private Integer pageNum = 1;
    private Integer pageSize = 50;
    private Integer totalPage;
    private Integer totalCount;

    private List<T> records = Collections.emptyList();

    public PageVO() {}
    public PageVO(IPage<T> page) {
        this(page.getCurrent(), page.getSize(), page.getTotal(), page.getRecords());
    }

    public PageVO(Long pageNum, Long pageSize, Long totalCount, List<T> records) {
        this(Math.toIntExact(pageNum), Math.toIntExact(pageSize), Math.toIntExact(totalCount), records);
    }

    public PageVO(Integer pageNum, Integer pageSize, Integer totalCount, List<T> records) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.totalCount = totalCount;
        if(this.totalCount>0){
            this.totalPage = (totalCount % pageSize == 0) ? totalCount/pageSize : (totalCount/pageSize) + 1;
        } else {
            this.totalPage = 0;
        }
        this.records = records;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public List<T> getRecords() {
        return records;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public Integer getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }
}
