/*
 * Decompiled with CFR 0.152.
 */
package cn.webestar.scms.commons;

import cn.webestar.scms.commons.CommonException;
import cn.webestar.scms.commons.SysCode;

public class Assert {
    public static void notNull(Object obj) throws CommonException {
        Assert.notNull(obj, SysCode.ERROR.getCode(), SysCode.ERROR.getMessage());
    }

    public static void notNull(Object obj, String errorMsg) throws CommonException {
        Assert.notNull(obj, SysCode.ERROR.getCode(), errorMsg);
    }

    public static void notNull(Object obj, Integer errorCode, String errorMsg) throws CommonException {
        if (obj == null) {
            Assert.throwCommonException(errorCode, errorMsg);
        }
    }

    public static void notEmpty(String obj) throws CommonException {
        Assert.notEmpty(obj, SysCode.ERROR.getCode(), SysCode.ERROR.getMessage());
    }

    public static void notEmpty(String obj, String errorMsg) throws CommonException {
        Assert.notEmpty(obj, SysCode.ERROR.getCode(), errorMsg);
    }

    public static void notEmpty(String obj, Integer errorCode, String errorMsg) throws CommonException {
        if (obj == null || obj.trim().isEmpty()) {
            Assert.throwCommonException(errorCode, errorMsg);
        }
    }

    public static void isTrue(boolean expression) throws CommonException {
        Assert.isTrue(expression, SysCode.ERROR.getCode(), SysCode.ERROR.getMessage());
    }

    public static void isTrue(boolean expression, String errorMsg) throws CommonException {
        Assert.isTrue(expression, SysCode.ERROR.getCode(), errorMsg);
    }

    public static void isTrue(boolean expression, Integer errorCode, String errorMsg) throws CommonException {
        if (!expression) {
            Assert.throwCommonException(errorCode, errorMsg);
        }
    }

    private static void throwCommonException(Integer errorCode, String errorMsg) throws CommonException {
        throw new CommonException(errorCode, errorMsg);
    }
}

