/*
 * Decompiled with CFR 0.152.
 */
package cn.wisewe.docx4j.convert;

import cn.wisewe.docx4j.convert.ConvertException;
import cn.wisewe.docx4j.convert.FileHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractConverter<T extends AbstractConverter<?, U>, U extends FileHandler> {
    protected BufferedInputStream inputStream;
    protected OutputStream outputStream;
    protected Function<String, ? extends ConvertException> messageConvertExceptionFunction;
    protected Function<Exception, ? extends ConvertException> exceptionConvertExceptionFunction;

    protected AbstractConverter(Function<String, ? extends ConvertException> messageConvertExceptionFunction, Function<Exception, ? extends ConvertException> exceptionConvertExceptionFunction) {
        this.messageConvertExceptionFunction = messageConvertExceptionFunction;
        this.exceptionConvertExceptionFunction = exceptionConvertExceptionFunction;
    }

    public T input(InputStream inputStream) {
        this.inputStream = new BufferedInputStream(inputStream);
        return (T)this;
    }

    public T input(File file) {
        try {
            return this.input(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw this.exceptionConvertExceptionFunction.apply(e);
        }
    }

    public T input(String fullFilePath) {
        return this.input(new File(fullFilePath));
    }

    public T output(OutputStream outputStream) {
        this.outputStream = outputStream;
        return (T)this;
    }

    public T output(File file) {
        try {
            return this.output(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw this.exceptionConvertExceptionFunction.apply(e);
        }
    }

    public T output(String fullFilePath) {
        return this.output(new File(fullFilePath));
    }

    public void convert(U type, boolean closeable) {
        if (Objects.isNull(this.inputStream)) {
            throw this.messageConvertExceptionFunction.apply("input stream not set");
        }
        if (Objects.isNull(this.outputStream)) {
            throw this.messageConvertExceptionFunction.apply("output stream not set");
        }
        try {
            type.getHandler().handle(this.inputStream, this.outputStream);
        }
        catch (Exception e) {
            if (e instanceof ConvertException) {
                throw (ConvertException)e;
            }
            throw this.exceptionConvertExceptionFunction.apply(e);
        }
        finally {
            if (Objects.nonNull(this.inputStream)) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    throw this.exceptionConvertExceptionFunction.apply(e);
                }
            }
            if (closeable && Objects.nonNull(this.outputStream)) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    throw this.exceptionConvertExceptionFunction.apply(e);
                }
            }
        }
    }

    public void convert(U type) {
        this.convert(type, true);
    }
}

