/*
 * Decompiled with CFR 0.152.
 */
package cn.wisewe.docx4j.convert.builder;

import cn.wisewe.docx4j.convert.ConvertException;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.jsoup.Jsoup;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class SvgTransfer {
    private final Supplier<List<byte[]>> supplier;
    private BiConsumer<Integer, Elements> consumer;
    private static final Parser PARSER = Parser.htmlParser();

    SvgTransfer(Supplier<List<byte[]>> supplier) {
        this.supplier = supplier;
    }

    public static SvgTransfer create(Supplier<List<byte[]>> supplier) {
        Objects.requireNonNull(supplier);
        return new SvgTransfer(supplier);
    }

    public SvgTransfer handle(BiConsumer<Integer, Elements> consumer) {
        Objects.requireNonNull(consumer);
        this.consumer = consumer;
        return this;
    }

    public void transfer(OutputStream outputStream) {
        Document document = new Document();
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            float height = document.getPageSize().getHeight();
            float width = document.getPageSize().getWidth();
            ArrayList<Image> list = new ArrayList<Image>();
            float totalHeight = 0.0f;
            float maxWidth = 0.0f;
            int index = 0;
            for (byte[] it : this.supplier.get()) {
                document.add((Element)new Chunk(""));
                Elements svg = Jsoup.parse((String)new String(it, StandardCharsets.UTF_8), (Parser)PARSER).select("svg");
                this.consumer.accept(index++, svg);
                StringReader reader = new StringReader(svg.toString());
                Throwable throwable = null;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                    Throwable throwable2 = null;
                    try {
                        TranscoderInput input = new TranscoderInput((Reader)reader);
                        TranscoderOutput output = new TranscoderOutput((OutputStream)baos);
                        new PNGTranscoder().transcode(input, output);
                        Image image = Image.getInstance((byte[])baos.toByteArray());
                        image.scaleToFit(document.getPageSize());
                        if (totalHeight + image.getScaledHeight() > height) {
                            this.render(list, writer, height, totalHeight, width - maxWidth);
                            maxWidth = image.getScaledWidth();
                            totalHeight = image.getScaledHeight();
                            list.clear();
                            document.newPage();
                        } else {
                            totalHeight += image.getScaledHeight();
                            maxWidth = Float.max(maxWidth, image.getScaledWidth());
                        }
                        list.add(image);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (baos == null) continue;
                        if (throwable2 != null) {
                            try {
                                baos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        baos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            if (!list.isEmpty()) {
                this.render(list, writer, height, totalHeight, width - maxWidth);
            }
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
        }
    }

    protected void render(List<Image> list, PdfWriter writer, float height, float totalHeight, float w) throws DocumentException {
        float th;
        for (th = height; th > totalHeight + totalHeight; th -= totalHeight) {
        }
        float h = (th - totalHeight) / (float)(list.size() + 1);
        float t = height - h;
        for (Image value : list) {
            value.setAbsolutePosition(w / 2.0f, t - value.getScaledHeight());
            writer.getDirectContent().addImage(value);
            t -= value.getScaledHeight();
            t -= h;
        }
    }

    static {
        PARSER.settings(new ParseSettings(true, true));
    }
}

