/*
 * Decompiled with CFR 0.152.
 */
package cn.wisewe.docx4j.convert.office;

import cn.wisewe.docx4j.convert.ConvertHandler;
import cn.wisewe.docx4j.convert.office.OfficeFileType;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public abstract class OfficeDocumentHandler<T>
implements ConvertHandler {
    protected abstract Supplier<T> newDocument();

    protected abstract BiConsumer<T, InputStream> preHandleFlat();

    protected abstract BiConsumer<T, InputStream> preHandleBinary();

    protected abstract BiConsumer<T, InputStream> preHandleZipped();

    @Override
    public void handle(BufferedInputStream inputStream, OutputStream outputStream) {
        T t = this.newDocument().get();
        switch (OfficeFileType.type(inputStream)) {
            case ZIP: {
                this.preHandleZipped().accept(t, inputStream);
                break;
            }
            case COMPOUND: {
                this.preHandleBinary().accept(t, inputStream);
                break;
            }
            default: {
                this.preHandleFlat().accept(t, inputStream);
            }
        }
        this.postHandle(t, outputStream);
    }

    protected abstract void postHandle(T var1, OutputStream var2);
}

