/*
 * Decompiled with CFR 0.152.
 */
package cn.wisewe.docx4j.convert.office;

import cn.wisewe.docx4j.convert.ConvertException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Arrays;

enum OfficeFileType {
    ZIP{

        @Override
        protected boolean match(byte[] bytes) {
            int first = 80;
            int second = 75;
            return bytes[0] == 80 && bytes[1] == 75;
        }
    }
    ,
    COMPOUND{

        @Override
        protected boolean match(byte[] bytes) {
            int first = -48;
            int second = -49;
            return bytes[0] == -48 && bytes[1] == -49;
        }
    }
    ,
    FLAT_OPC{

        @Override
        protected boolean match(byte[] bytes) {
            return true;
        }
    };


    protected abstract boolean match(byte[] var1);

    public static OfficeFileType type(BufferedInputStream bufferedInputStream) {
        int read;
        bufferedInputStream.mark(0);
        byte[] firstTwoBytes = new byte[2];
        try {
            read = bufferedInputStream.read(firstTwoBytes);
            bufferedInputStream.reset();
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        if (read != firstTwoBytes.length) {
            throw new ConvertException("file byte less than 2 bytes");
        }
        return Arrays.stream(OfficeFileType.values()).filter(it -> it.match(firstTwoBytes)).findFirst().orElseThrow(() -> new ConvertException("unknown file type"));
    }
}

