/*
 * Decompiled with CFR 0.152.
 */
package cn.wisewe.docx4j.convert.builder;

import cn.wisewe.docx4j.convert.ConvertException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class HtmlTransfer {
    private final Consumer<OutputStream> consumer;
    private Consumer<Document> handler;

    HtmlTransfer(Consumer<OutputStream> consumer) {
        this.consumer = consumer;
    }

    public static HtmlTransfer create(Consumer<OutputStream> consumer) {
        return new HtmlTransfer(consumer);
    }

    public HtmlTransfer handle(Consumer<Document> handler) {
        this.handler = handler;
        return this;
    }

    public void transfer(OutputStream outputStream) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);){
            this.consumer.accept(baos);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
                Document document = HtmlTransfer.parse(bais);
                if (Objects.nonNull(this.handler)) {
                    this.handler.accept(document);
                }
                HtmlTransfer.convert(document, outputStream);
            }
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected static Document parse(InputStream inputStream) {
        try {
            Document document = Jsoup.parse((InputStream)inputStream, (String)StandardCharsets.UTF_8.name(), (String)"");
            HtmlTransfer.appendMeta(document);
            return document;
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
    }

    public static void appendMeta(Document document) {
        Element mobile = new Element("meta");
        mobile.attr("name", "viewport");
        mobile.attr("content", "width=device-width,height=device-height, user-scalable=no,initial-scale=1, minimum-scale=1,maximum-scale=1,target-densitydpi=device-dpi");
        Element lang = new Element("meta");
        lang.attr("http-equiv", "Content-Type");
        lang.attr("content", "text/html; charset=utf-8");
        document.head().appendChildren(Arrays.asList(mobile, lang));
    }

    protected static void convert(Document document, OutputStream outputStream) {
        try {
            outputStream.write(document.html().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }
}

