/*
 * Decompiled with CFR 0.152.
 */
package cn.wisewe.docx4j.convert.builder.sheet;

import cn.wisewe.docx4j.convert.builder.HtmlTransfer;
import cn.wisewe.docx4j.convert.builder.sheet.SpreadSheetConvertException;
import cn.wisewe.docx4j.convert.builder.sheet.SpreadSheetHandler;
import com.aspose.cells.HtmlSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import com.aspose.cells.WorksheetCollection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

class HtmlHandler
extends SpreadSheetHandler {
    static final HtmlHandler INSTANCE = new HtmlHandler();
    private static final HtmlSaveOptions HTML_SAVE_OPTIONS = new HtmlSaveOptions();
    private static final String IFRAME_PREFIX = "iframe";
    private static final String NAV_SUFFIX = "nav";
    private static final Set<String> LINKS;

    private HtmlHandler() {
    }

    @Override
    protected void postHandle(Workbook workbook, OutputStream outputStream) {
        WorksheetCollection worksheets = workbook.getWorksheets();
        Document document = HtmlHandler.getDocument();
        HtmlTransfer.appendMeta(document);
        int size = worksheets.getCount();
        if (size > 0) {
            Element script = document.createElement("script");
            script.attr("type", "text/javascript");
            Element div = document.createElement("div");
            StringBuilder sb = new StringBuilder();
            sb.append("var holder; \n");
            sb.append("function onNavClick(id) {\n").append("if(holder) { \n").append("if(holder === id){return;}\n").append(String.format("document.getElementById(holder + '%s').classList.remove('active');\n", NAV_SUFFIX)).append("document.getElementById(holder).style.display='none'; \n").append("}\n").append("holder = id; \n").append(String.format("document.getElementById(id + '%s').classList.add('active');\n", NAV_SUFFIX)).append("document.getElementById(id).style.display='inline'; \n").append("}\n");
            IntStream.range(0, size).mapToObj(arg_0 -> ((WorksheetCollection)workbook.getWorksheets()).get(arg_0)).map(Worksheet.class::cast).forEach(it -> {
                int index = it.getIndex();
                worksheets.setActiveSheetIndex(index);
                String id = IFRAME_PREFIX + index;
                div.appendChild((Node)this.navElement(document, it.getName(), id));
                this.appendIframe(document, id);
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    HtmlTransfer.create(os -> {
                        try {
                            workbook.save(os, (SaveOptions)HTML_SAVE_OPTIONS);
                        }
                        catch (Exception e) {
                            throw new SpreadSheetConvertException(e);
                        }
                    }).handle(d -> {
                        d.head().getElementsByTag("link").stream().filter(e -> LINKS.contains(e.attr("rel"))).forEach(Node::remove);
                        d.body().getElementsByTag("script").stream().filter(e -> e.html().endsWith("ChangeIEBase64();")).forEach(Node::remove);
                    }).transfer(baos);
                    this.appendScript(sb, id, new String(baos.toByteArray(), StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new SpreadSheetConvertException(e.getMessage(), e);
                }
            });
            String style = "width: 100%;height: 30px;position: fixed;top: 0;left: 0;padding-left: 10px;background-color: rgba(53, 53, 53, 1);line-height: 30px;font-size: 14px; opacity: .6";
            div.attr("style", style);
            div.attr("id", "header-nav");
            document.body().appendChild((Node)div);
            sb.append(String.format("onNavClick('%s0');", IFRAME_PREFIX));
            script.append(sb.toString());
            document.body().appendChild((Node)script);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            baos.write(document.html().getBytes(StandardCharsets.UTF_8));
            outputStream.write(baos.toByteArray());
        }
        catch (IOException e) {
            throw new SpreadSheetConvertException(e.getMessage(), e);
        }
    }

    private static Document getDocument() {
        Document parse = Jsoup.parse((String)"");
        Element style = parse.createElement("style");
        style.attr("type", "text/css");
        String css = "a { padding: 5px; color: #f9f9f9; text-decoration:none; cursor:hand;}\na.active { color: #8df70c; }";
        style.append(css);
        parse.head().appendChild((Node)style);
        return parse;
    }

    private void appendScript(StringBuilder sb, String id, String body) {
        String temp = "t" + id;
        sb.append(String.format("var %s = document.getElementById(\"%s\");\n", id, id)).append(String.format("var %s = document.all ? %s.contentWindow.document : %s.contentDocument;\n", temp, id, id)).append(String.format("%s.open();\n", temp)).append(String.format("%s.write(`%s`);\n", temp, body)).append(String.format("%s.close();\n", temp));
    }

    private void appendIframe(Document document, String id) {
        Element iframe = document.createElement(IFRAME_PREFIX);
        iframe.attr("id", id);
        iframe.attr("frameborder", "0");
        iframe.attr("width", "100%");
        iframe.attr("height", "95%");
        iframe.attr("scrolling", "auto");
        iframe.attr("style", "padding-top: 30px; display: none");
        document.body().appendChild((Node)iframe);
    }

    private Element navElement(Document document, String title, String id) {
        Element a = document.createElement("a");
        a.attr("href", "javascript:void(0)");
        a.attr("id", id + NAV_SUFFIX);
        a.attr("onclick", String.format("onNavClick('%s')", id));
        a.text(title);
        return a;
    }

    static {
        HTML_SAVE_OPTIONS.setExportImagesAsBase64(true);
        HTML_SAVE_OPTIONS.setExportWorksheetCSSSeparately(false);
        HTML_SAVE_OPTIONS.setExportActiveWorksheetOnly(true);
        LINKS = new HashSet<String>(Arrays.asList("File-List", "Edit-Time-Data", "OLE-Object-Data"));
    }
}

