/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.cms.commons.ig;

import cn.wizzer.app.cms.commons.ig.IdGenerator;
import java.util.Date;
import java.util.List;
import org.nutz.integration.jedis.JedisAgent;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import redis.clients.jedis.Jedis;

@IocBean
public class RedisIdGenerator
implements IdGenerator {
    @Inject
    protected JedisAgent jedisAgent;

    public RedisIdGenerator() {
    }

    public RedisIdGenerator(JedisAgent jedisAgent) {
        this.jedisAgent = jedisAgent;
    }

    @Override
    public String next(String tableName, String prefix) {
        String key = prefix.toUpperCase();
        if (key.length() > 16) {
            key = key.substring(0, 16);
        }
        try (Jedis jedis = this.jedisAgent.getResource();){
            String ym = Times.format((String)"yyyyMM", (Date)new Date());
            String id = String.valueOf(jedis.incr("nutzwk:ig:" + tableName.toUpperCase() + ym));
            String string = key + ym + Strings.alignRight((Object)id, (int)10, (char)'0');
            return string;
        }
    }

    public Object run(List<Object> fetchParam) {
        return this.next((String)fetchParam.get(0), (String)fetchParam.get(1));
    }

    public String fetchSelf() {
        return "ig";
    }
}

