/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.filter;

import cn.wizzer.app.web.commons.utils.SignUtil;
import cn.wizzer.framework.base.Result;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionFilter;
import org.nutz.mvc.View;
import org.nutz.mvc.view.UTF8JsonView;

public class ApiSignFilter
implements ActionFilter {
    private static final Log log = Logs.get();

    public View match(ActionContext context) {
        try {
            PropertiesProxy conf = (PropertiesProxy)context.getIoc().get(PropertiesProxy.class, "conf");
            RedisService redisService = (RedisService)context.getIoc().get(RedisService.class);
            String appid_sys = conf.get("apitoken.appid", "");
            String appkey_sys = conf.get("apitoken.appkey", "");
            Map<String, Object> paramMap = this.getParameterMap(context.getRequest());
            String appid = Strings.sNull((Object)paramMap.get("appid"));
            String sign = Strings.sNull((Object)paramMap.get("sign"));
            String timestamp = Strings.sNull((Object)paramMap.get("timestamp"));
            String nonce = Strings.sNull((Object)paramMap.get("nonce"));
            if (!appid_sys.equals(appid)) {
                return new UTF8JsonView(JsonFormat.compact()).setData((Object)Result.error((int)1, (String)"appid\u4e0d\u6b63\u786e"));
            }
            if (Times.getTS() - Long.valueOf(timestamp) > 60000L) {
                return new UTF8JsonView(JsonFormat.compact()).setData((Object)Result.error((int)2, (String)"timestamp\u4e0d\u6b63\u786e"));
            }
            String nonceCache = redisService.get("api_sign_nonce:" + appid + "_" + nonce);
            if (Strings.isNotBlank((CharSequence)nonceCache)) {
                return new UTF8JsonView(JsonFormat.compact()).setData((Object)Result.error((int)3, (String)"nonce\u4e0d\u6b63\u786e"));
            }
            if (!SignUtil.createSign(appkey_sys, paramMap).equalsIgnoreCase(sign)) {
                return new UTF8JsonView(JsonFormat.compact()).setData((Object)Result.error((int)4, (String)"sign\u7b7e\u540d\u4e0d\u6b63\u786e"));
            }
            redisService.set("api_sign_nonce:" + appid + "_" + nonce, nonce);
            redisService.expire("api_sign_nonce:" + appid + "_" + nonce, 60);
            return null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new UTF8JsonView(JsonFormat.compact()).setData((Object)Result.error((int)-1, (String)"\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    private Map<String, Object> getParameterMap(HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String paramName = (String)names.nextElement();
            map.put(paramName, request.getParameter(paramName));
        }
        return map;
    }
}

