/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.utils;

import cn.wizzer.app.web.commons.utils.SignUtil;
import cn.wizzer.framework.base.Result;
import java.util.Map;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class SignCheckUtil {
    private static final Log log = Logs.get();
    @Inject
    private PropertiesProxy conf;
    @Inject
    private RedisService redisService;

    public Result checkSign(Map<String, Object> paramMap) {
        try {
            String appid_sys = this.conf.get("apitoken.appid", "");
            String appkey_sys = this.conf.get("apitoken.appkey", "");
            String appid = Strings.sNull((Object)paramMap.get("appid"));
            String sign = Strings.sNull((Object)paramMap.get("sign"));
            String timestamp = Strings.sNull((Object)paramMap.get("timestamp"));
            String nonce = Strings.sNull((Object)paramMap.get("nonce"));
            if (!appid_sys.equals(appid)) {
                return Result.error((int)1, (String)"appid\u4e0d\u6b63\u786e");
            }
            if (Times.getTS() - Long.valueOf(timestamp) > 60000L) {
                return Result.error((int)2, (String)"timestamp\u4e0d\u6b63\u786e");
            }
            String nonceCache = this.redisService.get("api_sign_nonce:" + appid + "_" + nonce);
            if (Strings.isNotBlank((CharSequence)nonceCache)) {
                return Result.error((int)3, (String)"nonce\u4e0d\u6b63\u786e");
            }
            if (!SignUtil.createSign(appkey_sys, paramMap).equalsIgnoreCase(sign)) {
                return Result.error((int)4, (String)"sign\u7b7e\u540d\u4e0d\u6b63\u786e");
            }
            this.redisService.set("api_sign_nonce:" + appid + "_" + nonce, nonce);
            this.redisService.expire("api_sign_nonce:" + appid + "_" + nonce, 60);
            return Result.success((String)"\u9a8c\u8bc1\u6210\u529f");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((int)-1, (String)"\u7cfb\u7edf\u5f02\u5e38");
        }
    }
}

