/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.utils;

import cn.wizzer.app.sys.modules.services.SysApiService;
import cn.wizzer.app.web.commons.utils.SignUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.Map;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class SignCheckUtil {
    private static final Log log = Logs.get();
    @Inject
    private PropertiesProxy conf;
    @Inject
    @Reference
    private SysApiService sysApiService;
    @Inject
    private RedisService redisService;

    public Result checkSign(Map<String, Object> paramMap) {
        try {
            String appid = Strings.sNull((Object)paramMap.get("appid"));
            String sign = Strings.sNull((Object)paramMap.get("sign"));
            String timestamp = Strings.sNull((Object)paramMap.get("timestamp"));
            String nonce = Strings.sNull((Object)paramMap.get("nonce"));
            String appkey = this.sysApiService.getAppkey(appid);
            if (Strings.isBlank((CharSequence)appid) || Strings.isBlank((CharSequence)appkey)) {
                return Result.error((int)1, (String)"appid\u4e0d\u6b63\u786e");
            }
            if (Times.getTS() - Long.valueOf(timestamp) > 60000L) {
                return Result.error((int)2, (String)"timestamp\u4e0d\u6b63\u786e");
            }
            String nonceCache = this.redisService.get("api_sign_nonce:" + appid + "_" + nonce);
            if (Strings.isNotBlank((CharSequence)nonceCache)) {
                return Result.error((int)3, (String)"nonce\u4e0d\u6b63\u786e");
            }
            if (!SignUtil.createSign(appkey, paramMap).equalsIgnoreCase(sign)) {
                return Result.error((int)4, (String)"sign\u7b7e\u540d\u4e0d\u6b63\u786e");
            }
            this.redisService.setex("api_sign_nonce:" + appid + "_" + nonce, 60, nonce);
            return Result.success((String)"\u9a8c\u8bc1\u6210\u529f");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((int)-1, (String)"\u7cfb\u7edf\u5f02\u5e38");
        }
    }
}

