/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.crypto.MacProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.util.Date;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;

@IocBean
public class TokenUtil {
    @Inject
    private RedisService redisService;

    private Key getKey(String appid) throws IOException, ClassNotFoundException {
        Key key;
        byte[] obj = this.redisService.get(("api_token:" + appid).getBytes());
        if (obj != null) {
            ObjectInputStream keyIn = new ObjectInputStream(new ByteArrayInputStream(obj));
            key = (Key)keyIn.readObject();
            keyIn.close();
        } else {
            key = MacProvider.generateKey();
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bao);
            oos.writeObject(key);
            obj = bao.toByteArray();
            this.redisService.setex(("api_token:" + appid).getBytes(), 7202, obj);
        }
        return key;
    }

    public String generateToken(Date date, String appid) throws IOException, ClassNotFoundException {
        return Jwts.builder().setSubject(appid).signWith(SignatureAlgorithm.HS512, this.getKey(appid)).setExpiration(date).compact();
    }

    public boolean verifyToken(String appid, String token) {
        try {
            return ((Claims)Jwts.parser().setSigningKey(this.getKey(appid)).parseClaimsJws(token).getBody()).getSubject().equals(appid);
        }
        catch (Exception e) {
            return false;
        }
    }
}

