/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_route;
import cn.wizzer.app.sys.modules.services.SysRouteService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.util.StringUtils;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.integration.jedis.pubsub.PubSubService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/route"})
public class SysRouteController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysRouteService routeService;
    @Inject
    private PubSubService pubSubService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/route/index.html")
    @RequiresPermissions(value={"sys.manager.route"})
    public void index() {
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.route"})
    public Object data(@Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        return this.routeService.data(length, start, draw, order, columns, cnd, null);
    }

    @At
    @Ok(value="beetl:/platform/sys/route/add.html")
    @RequiresPermissions(value={"sys.manager.route"})
    public void add() {
    }

    @At
    @Ok(value="json")
    @SLog(tag="\u65b0\u5efa\u8def\u7531", msg="URL:${args[0].url}")
    @RequiresPermissions(value={"sys.manager.route.add"})
    public Object addDo(@Param(value="..") Sys_route route, HttpServletRequest req) {
        try {
            this.routeService.insert((Object)route);
            this.pubSubService.fire("nutzwk:web:platform", "sys_route");
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/sys/route/edit.html")
    @RequiresPermissions(value={"sys.manager.route"})
    public Object edit(String id) {
        return this.routeService.fetch(id);
    }

    @At
    @Ok(value="json")
    @SLog(tag="\u4fee\u6539\u8def\u7531", msg="URL:${args[0].url}")
    @RequiresPermissions(value={"sys.manager.route.edit"})
    public Object editDo(@Param(value="..") Sys_route route, HttpServletRequest req) {
        try {
            route.setOpBy(StringUtil.getPlatformUid());
            route.setOpAt(Long.valueOf(Times.getTS()));
            this.routeService.updateIgnoreNull((Object)route);
            this.pubSubService.fire("nutzwk:web:platform", "sys_route");
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete", "/delete/?"})
    @Ok(value="json")
    @SLog(tag="\u5220\u9664\u8def\u7531", msg="\u8def\u7531ID:${args[2].getAttribute('id')}")
    @RequiresPermissions(value={"sys.manager.route.delete"})
    public Object delete(String id, @Param(value="ids") String[] ids, HttpServletRequest req) {
        try {
            if (ids != null && ids.length > 0) {
                this.routeService.delete(ids);
                req.setAttribute("id", (Object)StringUtils.toString((Object[])ids));
            } else {
                this.routeService.delete(id);
                req.setAttribute("id", (Object)id);
            }
            this.pubSubService.fire("nutzwk:web:platform", "sys_route");
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.route.edit"})
    @SLog(tag="\u542f\u7528\u8def\u7531", msg="URL:${args[1].getAttribute('url')}")
    public Object enable(String id, HttpServletRequest req) {
        try {
            Sys_route route = (Sys_route)this.routeService.fetch(id);
            req.setAttribute("url", (Object)route.getUrl());
            this.routeService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            this.pubSubService.fire("nutzwk:web:platform", "sys_route");
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.route.edit"})
    @SLog(tag="\u7981\u7528\u8def\u7531", msg="URL:${args[1].getAttribute('name')}")
    public Object disable(String id, HttpServletRequest req) {
        try {
            Sys_route route = (Sys_route)this.routeService.fetch(id);
            req.setAttribute("url", (Object)route.getUrl());
            this.routeService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            this.pubSubService.fire("nutzwk:web:platform", "sys_route");
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

