/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_mass;
import cn.wizzer.app.wx.modules.models.Wx_mass_news;
import cn.wizzer.app.wx.modules.models.Wx_mass_send;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxMassNewsService;
import cn.wizzer.app.wx.modules.services.WxMassSendService;
import cn.wizzer.app.wx.modules.services.WxMassService;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.impl.AdaptorErrorContext;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadAdaptor;
import org.nutz.weixin.bean.WxMassArticle;
import org.nutz.weixin.bean.WxOutMsg;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/platform/wx/msg/mass"})
public class WxMassController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxMassService wxMassService;
    @Inject
    @Reference
    private WxMassSendService wxMassSendService;
    @Inject
    @Reference
    private WxMassNewsService wxMassNewsService;
    @Inject
    @Reference
    private WxConfigService wxConfigService;
    @Inject
    private WxService wxService;

    @At(value={"/", "/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/index.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public void index(String wxid, HttpServletRequest req) {
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxid = ((Wx_config)list.get(0)).getId();
        }
        req.setAttribute("wxid", (Object)wxid);
        req.setAttribute("wxList", (Object)list);
    }

    @At(value={"/massData/", "/massData/?"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.msg.mass"})
    public Object massData(String wxid, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        return this.wxMassService.data(length, start, draw, order, columns, cnd, null);
    }

    @At(value={"/news/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/news.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public void news(String wxid, HttpServletRequest req) {
        req.setAttribute("wxid", (Object)wxid);
    }

    @At(value={"/newsData/?"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.msg.mass"})
    public Object newsData(String wxid, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        return this.wxMassNewsService.data(length, start, draw, order, columns, cnd, null);
    }

    @At(value={"/deleteNews/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.msg.mass.delNews"})
    @SLog(tag="\u5220\u9664\u56fe\u6587", msg="\u56fe\u6587\u6807\u9898:${args[1].getAttribute('title')}}")
    public Object deleteNews(String id, HttpServletRequest req) {
        try {
            req.setAttribute("title", (Object)((Wx_mass_news)this.wxMassNewsService.fetch(id)).getTitle());
            this.wxMassNewsService.delete(id);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/addNews/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/add.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public void add(String wxid, HttpServletRequest req) {
        req.setAttribute("wxid", (Object)wxid);
        req.getSession().setAttribute("wxid", (Object)wxid);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.msg.mass.addNews"})
    @SLog(tag="\u6dfb\u52a0\u56fe\u6587", msg="\u56fe\u6587\u6807\u9898:${args[0].title}")
    public Object addDo(@Param(value="..") Wx_mass_news news, HttpServletRequest req) {
        try {
            this.wxMassNewsService.insert((Object)news);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/newsDetail/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/detail.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public Object newsDetail(String id, HttpServletRequest req) {
        return this.wxMassNewsService.fetch(id);
    }

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:imageUpload"})
    @POST
    @At(value={"/uploadThumb/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.msg.mass"})
    public Object uploadThumb(String wxid, @Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            WxResp resp = wxApi2.media_upload("thumb", tf.getFile());
            if (resp.errcode() != 0) {
                return Result.error((String)resp.errmsg());
            }
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)resp.get((Object)"thumb_media_id"));
        }
        catch (Exception e) {
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            return Result.error((String)"\u56fe\u7247\u683c\u5f0f\u9519\u8bef");
        }
    }

    @At(value={"/send/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/send.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public void send(String wxid, HttpServletRequest req) {
        req.setAttribute("wxid", (Object)wxid);
    }

    @At(value={"/select/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/select.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public void select(String wxid, HttpServletRequest req) {
        req.setAttribute("wxid", (Object)wxid);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.msg.mass.pushNews"})
    @SLog(tag="\u7fa4\u53d1\u6d88\u606f", msg="\u7fa4\u53d1\u540d\u79f0:${args[0].name}")
    public Object sendDo(@Param(value="..") Wx_mass mass, @Param(value="content") String content, @Param(value="openids") String openids, HttpServletRequest req) {
        try {
            WxResp resp;
            WxApi2 wxApi2 = this.wxService.getWxApi2(mass.getWxid());
            WxOutMsg outMsg = new WxOutMsg();
            if ("news".equals(mass.getType())) {
                String[] ids = StringUtils.split((String)content, (String)",");
                int i = 0;
                for (String id : ids) {
                    this.wxMassNewsService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
                    ++i;
                }
                List newsList = this.wxMassNewsService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)ids).asc("location"));
                List articles = Json.fromJsonAsList(WxMassArticle.class, (CharSequence)Json.toJson((Object)newsList));
                WxResp resp2 = wxApi2.uploadnews(articles);
                String media_id = resp2.media_id();
                mass.setMedia_id(media_id);
                outMsg.setMedia_id(media_id);
                outMsg.setMsgType("mpnews");
            }
            if ("text".equals(mass.getType())) {
                outMsg.setContent(content);
                outMsg.setMsgType("text");
            }
            if ("all".equals(mass.getScope())) {
                resp = wxApi2.mass_sendall(true, null, outMsg);
            } else {
                String[] ids = StringUtils.split((String)openids, (String)",");
                resp = wxApi2.mass_send(Arrays.asList(ids), outMsg);
            }
            mass.setStatus(Integer.valueOf(resp.errcode() == 0 ? 1 : 2));
            Wx_mass wxMass = (Wx_mass)this.wxMassService.insert((Object)mass);
            Wx_mass_send send = new Wx_mass_send();
            send.setWxid(wxMass.getWxid());
            send.setMassId(wxMass.getId());
            send.setErrCode(String.valueOf(resp.errcode()));
            send.setMsgId(resp.getString("msg_id"));
            if (!"all".equals(mass.getScope())) {
                send.setReceivers(content);
            }
            send.setErrMsg(resp.getString("errmsg"));
            send.setStatus(Integer.valueOf(resp.errcode() == 0 ? 1 : 2));
            this.wxMassSendService.insert((Object)send);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/sendDetail/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/sendDetail.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public Object sendDetail(String id, HttpServletRequest req) {
        Wx_mass mass = (Wx_mass)this.wxMassService.fetch(id);
        if ("news".equals(mass.getType())) {
            String[] ids = StringUtils.split((String)mass.getContent(), (String)",");
            req.setAttribute("news", (Object)this.wxMassNewsService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)ids).asc("location")));
        }
        req.setAttribute("send", this.wxMassSendService.fetch((Condition)Cnd.where((String)"massId", (String)"=", (Object)mass.getId())));
        return mass;
    }
}

