/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_reply;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxReplyNewsService;
import cn.wizzer.app.wx.modules.services.WxReplyService;
import cn.wizzer.app.wx.modules.services.WxReplyTxtService;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/wx/reply/conf"})
public class WxReplyController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxReplyTxtService wxReplyTxtService;
    @Inject
    @Reference
    private WxReplyNewsService wxReplyNewsService;
    @Inject
    @Reference
    private WxReplyService wxReplyService;
    @Inject
    @Reference
    private WxConfigService wxConfigService;

    @At(value={"/?"})
    @Ok(value="beetl:/platform/wx/reply/conf/index.html")
    @RequiresPermissions(value={"wx.reply"})
    public void index(String type, @Param(value="wxid") String wxid, HttpServletRequest req) {
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxid = ((Wx_config)list.get(0)).getId();
        }
        req.setAttribute("wxList", (Object)list);
        req.setAttribute("wxid", (Object)wxid);
        req.setAttribute("type", (Object)type);
    }

    @At(value={"/?/add"})
    @Ok(value="beetl:/platform/wx/reply/conf/add.html")
    @RequiresPermissions(value={"wx.reply"})
    public void add(String type, @Param(value="wxid") String wxid, HttpServletRequest req) {
        req.setAttribute("config", this.wxConfigService.fetch(wxid));
        req.setAttribute("type", (Object)type);
        req.setAttribute("wxid", (Object)wxid);
    }

    @At(value={"/?/addDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.follow.add", "wx.reply.keyword.add"}, logical=Logical.OR)
    @SLog(tag="\u6dfb\u52a0\u7ed1\u5b9a", msg="\u7ed1\u5b9a\u7c7b\u578b:${args[0]}")
    public Object addDo(String type, @Param(value="..") Wx_reply reply, HttpServletRequest req) {
        try {
            int c;
            if ("follow".equals(reply.getType()) && (c = this.wxReplyService.count((Condition)Cnd.where((String)"type", (String)"=", (Object)"follow").and("wxid", "=", (Object)reply.getWxid()))) > 0) {
                return Result.error((String)"\u5173\u6ce8\u4e8b\u4ef6\u53ea\u53ef\u8bbe\u7f6e\u4e00\u6761");
            }
            if ("keyword".equals(reply.getType()) && (c = this.wxReplyService.count((Condition)Cnd.where((String)"keyword", (String)"=", (Object)reply.getKeyword()).and("wxid", "=", (Object)reply.getWxid()))) > 0) {
                return Result.error((String)"\u5173\u952e\u8bcd\u5df2\u5b58\u5728");
            }
            this.wxReplyService.insert((Object)reply);
            if ("news".equals(reply.getMsgType())) {
                String[] newsIds = Strings.sBlank((Object)reply.getContent()).split(",");
                int i = 0;
                for (String id : newsIds) {
                    this.wxReplyNewsService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
                    ++i;
                }
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/?/edit/?"})
    @Ok(value="beetl:/platform/wx/reply/conf/edit.html")
    @RequiresPermissions(value={"wx.reply"})
    public Object edit(String type, String id, HttpServletRequest req) {
        Wx_reply reply = (Wx_reply)this.wxReplyService.fetch(id);
        if ("txt".equals(reply.getMsgType())) {
            req.setAttribute("txt", this.wxReplyTxtService.fetch(reply.getContent()));
        } else if ("news".equals(reply.getMsgType())) {
            String[] newsIds = Strings.sBlank((Object)reply.getContent()).split(",");
            List newsList = this.wxReplyNewsService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)newsIds).asc("location"));
            req.setAttribute("news", (Object)newsList);
        }
        req.setAttribute("type", (Object)reply.getType());
        req.setAttribute("wxid", (Object)reply.getWxid());
        req.setAttribute("config", this.wxConfigService.fetch(reply.getWxid()));
        return reply;
    }

    @At(value={"/?/editDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.follow.edit", "wx.reply.keyword.edit"}, logical=Logical.OR)
    @SLog(tag="\u4fee\u6539\u7ed1\u5b9a", msg="\u7ed1\u5b9a\u7c7b\u578b:${args[0]}")
    public Object editDo(String type, @Param(value="..") Wx_reply reply, HttpServletRequest req) {
        try {
            this.wxReplyService.updateIgnoreNull((Object)reply);
            if ("news".equals(reply.getMsgType())) {
                String[] newsIds = Strings.sBlank((Object)reply.getContent()).split(",");
                int i = 0;
                for (String id : newsIds) {
                    this.wxReplyNewsService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
                    ++i;
                }
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/?/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.follow.delete", "wx.reply.keyword.delete"}, logical=Logical.OR)
    @SLog(tag="\u5220\u9664\u7ed1\u5b9a", msg="\u7ed1\u5b9a\u7c7b\u578b:${args[0]}")
    public Object delete(String type, String id, HttpServletRequest req) {
        try {
            this.wxReplyService.delete(id);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/?/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.follow.delete", "wx.reply.keyword.delete"}, logical=Logical.OR)
    @SLog(tag="\u5220\u9664\u7ed1\u5b9a", msg="\u7ed1\u5b9a\u7c7b\u578b:${args[0]}")
    public Object deletes(String type, @Param(value="ids") String id, HttpServletRequest req) {
        try {
            this.wxReplyService.delete(StringUtils.split((String)id, (String)","));
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/?/data"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.reply"})
    public Object data(String type, @Param(value="wxid") String wxid, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)type)) {
            cnd.and("type", "=", (Object)type);
        }
        if (!Strings.isBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        return this.wxReplyService.data(length, start, draw, order, columns, cnd, null);
    }

    @At(value={"/?/select"})
    @Ok(value="beetl:/platform/wx/reply/conf/select.html")
    @RequiresPermissions(value={"wx.reply"})
    public void select(String type, @Param(value="wxid") String wxid, @Param(value="msgType") String msgType, HttpServletRequest req) {
        req.setAttribute("type", (Object)type);
        req.setAttribute("wxid", (Object)wxid);
        req.setAttribute("msgType", (Object)msgType);
    }

    @At(value={"/?/selectData"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.reply"})
    public Object selectData(String type, @Param(value="msgType") String msgType, @Param(value="wxid") String wxid, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        if ("txt".equals(msgType)) {
            return this.wxReplyTxtService.data(length, start, draw, order, columns, cnd, null);
        }
        return this.wxReplyNewsService.data(length, start, draw, order, columns, cnd, null);
    }
}

