/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.slog;

import cn.wizzer.app.web.commons.slog.SLogService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.nutz.aop.InterceptorChain;
import org.nutz.aop.MethodInterceptor;
import org.nutz.el.El;
import org.nutz.ioc.Ioc;
import org.nutz.lang.Lang;
import org.nutz.lang.segment.CharSegment;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;

public class SLogAopInterceptor
implements MethodInterceptor {
    private static final Log log = Logs.get();
    protected SLogService sLogService;
    protected String source;
    protected String type;
    protected String tag;
    protected CharSegment msg;
    protected boolean param;
    protected boolean result;
    protected boolean async;
    protected Map<String, El> els;
    protected Ioc ioc;

    public SLogAopInterceptor(Ioc ioc, SLog slog, Method method) {
        this.msg = new CharSegment(slog.msg());
        if (this.msg.hasKey()) {
            this.els = new HashMap<String, El>();
            for (String key : this.msg.keys()) {
                this.els.put(key, new El((CharSequence)key));
            }
        }
        this.param = slog.param();
        this.result = slog.result();
        this.ioc = ioc;
        this.source = method.getDeclaringClass().getName() + "#" + method.getName();
        this.tag = slog.tag();
        SLog _s = method.getDeclaringClass().getAnnotation(SLog.class);
        if (_s != null) {
            this.tag = _s.tag() + "," + this.tag;
        }
        this.type = slog.type();
        this.async = slog.async();
    }

    public void filter(InterceptorChain chain) throws Throwable {
        try {
            chain.doChain();
            this.doLog("aop.after", chain, null);
        }
        catch (Throwable e) {
            this.doLog("aop.error", chain, e);
            throw e;
        }
    }

    protected void doLog(String t, InterceptorChain chain, Throwable e) {
        String _msg = null;
        if (this.msg.hasKey()) {
            Context ctx = Lang.context();
            ctx.set("args", (Object)chain.getArgs());
            ctx.set("return", chain.getReturn());
            ctx.set("req", (Object)Mvcs.getReq());
            ctx.set("resp", (Object)Mvcs.getResp());
            Context _ctx = Lang.context();
            for (String key : this.msg.keys()) {
                _ctx.set(key, this.els.get(key).eval(ctx));
            }
            _msg = this.msg.render(_ctx).toString();
        } else {
            _msg = this.msg.getOrginalString();
        }
        if (this.sLogService == null) {
            this.sLogService = (SLogService)this.ioc.get(SLogService.class);
        }
        try {
            this.sLogService.log(t, this.type, this.tag, this.source, _msg, this.els, this.param, this.result, this.async, chain.getArgs(), chain.getReturn(), chain.getCallingMethod(), chain.getCallingObj(), e);
        }
        catch (Exception e1) {
            log.debug((Object)"slog fail", (Throwable)e1);
        }
    }
}

