/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.slog;

import cn.wizzer.app.sys.modules.models.Sys_log;
import cn.wizzer.app.sys.modules.services.SysLogService;
import cn.wizzer.app.web.commons.utils.StringUtil;
import com.alibaba.dubbo.config.annotation.Reference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.nutz.el.El;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;

@IocBean(create="init", depose="close")
public class SLogService
implements Runnable {
    private static final Log log = Logs.get();
    ExecutorService es;
    LinkedBlockingQueue<Sys_log> queue;
    @Inject
    @Reference
    protected SysLogService sysLogService;
    protected static Map<String, Map<String, List<String>>> caches = new HashMap<String, Map<String, List<String>>>();

    public void async(Sys_log syslog) {
        LinkedBlockingQueue<Sys_log> queue = this.queue;
        if (queue != null) {
            try {
                boolean re = queue.offer(syslog, 50L, TimeUnit.MILLISECONDS);
                if (!re) {
                    log.info((Object)"syslog queue is full, drop it ...");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void sync(Sys_log syslog) {
        try {
            this.sysLogService.fastInsertSysLog(syslog);
        }
        catch (Throwable e) {
            log.info((Object)"insert syslog sync fail", e);
        }
    }

    @Override
    public void run() {
        LinkedBlockingQueue<Sys_log> queue;
        while ((queue = this.queue) != null) {
            try {
                Sys_log sysLog = queue.poll(1L, TimeUnit.SECONDS);
                if (sysLog == null) continue;
                this.sync(sysLog);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void log(String t, String type, String tag, String source, String msg, Map<String, El> els, boolean param, boolean result, boolean async, Object[] args, Object re, Method method, Object obj, Throwable e) {
        String _param = "";
        String _result = "";
        if (param && args != null) {
            _param = Json.toJson((Object)args);
        }
        if (result && re != null) {
            _result = Json.toJson((Object)re);
        }
        this.log(type, tag, source, msg, async, _param, _result);
    }

    public void log(String type, String tag, String source, String msg, boolean async, String param, String result) {
        Sys_log slog = SLogService.makeLog(type, tag, source, msg, param, result);
        if (async) {
            this.async(slog);
        } else {
            this.sync(slog);
        }
    }

    public void init() {
        this.queue = new LinkedBlockingQueue();
        int c = Runtime.getRuntime().availableProcessors();
        this.es = Executors.newFixedThreadPool(c);
        for (int i = 0; i < c; ++i) {
            this.es.submit(this);
        }
    }

    public void close() throws InterruptedException {
        this.queue = null;
        if (this.es != null && !this.es.isShutdown()) {
            this.es.shutdown();
            this.es.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public static Sys_log makeLog(String type, String tag, String source, String msg, String param, String result) {
        Sys_log sysLog = new Sys_log();
        if (type == null || tag == null) {
            throw new RuntimeException("type/tag can't null");
        }
        if (source == null) {
            StackTraceElement[] tmp = Thread.currentThread().getStackTrace();
            source = tmp.length > 2 ? tmp[2].getClassName() + "#" + tmp[2].getMethodName() : "main";
        }
        sysLog.setType(type);
        sysLog.setTag(tag);
        sysLog.setSrc(source);
        sysLog.setMsg(msg);
        sysLog.setParam(param);
        sysLog.setResult(result);
        if (Mvcs.getReq() != null) {
            sysLog.setIp(Lang.getIP((HttpServletRequest)Mvcs.getReq()));
        }
        sysLog.setOpBy(StringUtil.getPlatformUid());
        sysLog.setOpAt(Long.valueOf(Times.getTS()));
        sysLog.setDelFlag(Boolean.valueOf(false));
        sysLog.setUsername(StringUtil.getPlatformUsername());
        return sysLog;
    }
}

