/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.open.file;

import cn.wizzer.app.web.commons.base.Globals;
import cn.wizzer.app.web.commons.utils.DateUtil;
import cn.wizzer.framework.base.Result;
import java.io.File;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Files;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.impl.AdaptorErrorContext;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadAdaptor;

@IocBean
@At(value={"/open/file/upload"})
public class UploadController {
    private static final Log log = Logs.get();

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:fileUpload"})
    @POST
    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object file(@Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            String s = tf.getSubmittedFileName().substring(tf.getSubmittedFileName().indexOf(".") + 1);
            String uri = "/file/" + DateUtil.format(new Date(), "yyyyMMdd") + "/" + R.UU32() + tf.getSubmittedFileName().substring(tf.getSubmittedFileName().indexOf("."));
            String f = Globals.AppUploadPath + uri;
            Files.write((File)new File(f), (Object)tf.getInputStream());
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("file_type", (Object)s.toLowerCase()).addv("file_name", (Object)tf.getName()).addv("file_size", (Object)tf.getSize()).addv("file_url", (Object)(Globals.AppUploadBase + uri)));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            return Result.error((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
        }
    }

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:videoUpload"})
    @POST
    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object video(@Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            String s = tf.getSubmittedFileName().substring(tf.getSubmittedFileName().indexOf(".") + 1);
            String uri = "/video/" + DateUtil.format(new Date(), "yyyyMMdd") + "/" + R.UU32() + tf.getSubmittedFileName().substring(tf.getSubmittedFileName().indexOf("."));
            String f = Globals.AppUploadPath + uri;
            Files.write((File)new File(f), (Object)tf.getInputStream());
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("file_type", (Object)s.toLowerCase()).addv("file_name", (Object)tf.getName()).addv("file_size", (Object)tf.getSize()).addv("file_url", (Object)(Globals.AppUploadBase + uri)));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            return Result.error((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
        }
    }

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:imageUpload"})
    @POST
    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object image(@Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            String uri = "/image/" + DateUtil.format(new Date(), "yyyyMMdd") + "/" + R.UU32() + tf.getSubmittedFileName().substring(tf.getSubmittedFileName().indexOf("."));
            String f = Globals.AppUploadPath + uri;
            Files.write((File)new File(f), (Object)tf.getInputStream());
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)(Globals.AppUploadBase + uri));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            return Result.error((String)"\u56fe\u7247\u683c\u5f0f\u9519\u8bef");
        }
    }
}

