/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_menu;
import cn.wizzer.app.sys.modules.services.SysMenuService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/menu"})
public class SysMenuController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysMenuService sysMenuService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/menu/index.html")
    @RequiresPermissions(value={"sys.manager.menu"})
    public void index(HttpServletRequest req) {
        req.setAttribute("list", (Object)this.sysMenuService.query((Condition)Cnd.where((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null).asc("location").asc("path")));
    }

    @At
    @Ok(value="beetl:/platform/sys/menu/add.html")
    @RequiresPermissions(value={"sys.manager.menu"})
    public Object add(@Param(value="pid") String pid, HttpServletRequest req) {
        return Strings.isBlank((CharSequence)pid) ? null : this.sysMenuService.fetch(pid);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.add"})
    @SLog(tag="\u65b0\u5efa\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[0].name}")
    public Object addDo(@Param(value="..") Sys_menu menu, @Param(value="parentId") String parentId, HttpServletRequest req) {
        try {
            int num = this.sysMenuService.count((Condition)Cnd.where((String)"permission", (String)"=", (Object)menu.getPermission().trim()));
            if (num > 0) {
                return Result.error((String)"sys.role.code");
            }
            if ("data".equals(menu.getType())) {
                menu.setIsShow(false);
            } else {
                menu.setIsShow(true);
            }
            menu.setOpBy(StringUtil.getPlatformUid());
            this.sysMenuService.save(menu, parentId, null);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/sys/menu/edit.html")
    @RequiresPermissions(value={"sys.manager.menu"})
    public Object edit(String id, HttpServletRequest req) {
        Sys_menu menu = (Sys_menu)this.sysMenuService.fetch(id);
        if (menu != null) {
            req.setAttribute("parentMenu", this.sysMenuService.fetch(menu.getParentId()));
        }
        return menu;
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.edit"})
    @SLog(tag="\u7f16\u8f91\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[0].name}")
    public Object editDo(@Param(value="..") Sys_menu menu, @Param(value="oldPermission") String oldPermission, HttpServletRequest req) {
        try {
            int num;
            if (!Strings.sBlank((Object)oldPermission).equals(menu.getPermission()) && (num = this.sysMenuService.count((Condition)Cnd.where((String)"permission", (String)"=", (Object)menu.getPermission().trim()))) > 0) {
                return Result.error((String)"sys.role.code");
            }
            menu.setOpBy(StringUtil.getPlatformUid());
            menu.setOpAt(Long.valueOf(Times.getTS()));
            this.sysMenuService.updateIgnoreNull((Object)menu);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.delete"})
    @SLog(tag="\u5220\u9664\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            Sys_menu menu = (Sys_menu)this.sysMenuService.fetch(id);
            req.setAttribute("name", (Object)menu.getName());
            if (menu.getPath().startsWith("0001")) {
                return Result.error((String)"system.not.allow");
            }
            this.sysMenuService.deleteAndChild(menu);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.edit"})
    @SLog(tag="\u542f\u7528\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object enable(String menuId, HttpServletRequest req) {
        try {
            req.setAttribute("name", (Object)((Sys_menu)this.sysMenuService.fetch(menuId)).getName());
            this.sysMenuService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)menuId));
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.edit"})
    @SLog(tag="\u7981\u7528\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object disable(String menuId, HttpServletRequest req) {
        try {
            req.setAttribute("name", (Object)((Sys_menu)this.sysMenuService.fetch(menuId)).getName());
            this.sysMenuService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)menuId));
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu"})
    public Object tree(@Param(value="pid") String pid) {
        Cnd cnd = Cnd.NEW();
        if (Strings.isBlank((CharSequence)pid)) {
            cnd.and((SqlExpression)Cnd.exps((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null));
        } else {
            cnd.and("parentId", "=", (Object)pid);
        }
        cnd.and("type", "=", (Object)"menu");
        cnd.asc("location").asc("path");
        List list = this.sysMenuService.query((Condition)cnd);
        ArrayList tree = new ArrayList();
        for (Sys_menu menu : list) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("id", menu.getId());
            obj.put("text", menu.getName());
            obj.put("children", menu.isHasChildren());
            tree.add(obj);
        }
        return tree;
    }

    @At(value={"/child/?"})
    @Ok(value="beetl:/platform/sys/menu/child.html")
    @RequiresPermissions(value={"sys.manager.menu"})
    public Object child(String id) {
        Sys_menu m = (Sys_menu)this.sysMenuService.fetch(id);
        ArrayList<Sys_menu> list = new ArrayList<Sys_menu>();
        List menus = this.sysMenuService.query((Condition)Cnd.where((String)"parentId", (String)"=", (Object)id).asc("location").asc("path"));
        List datas = this.sysMenuService.query((Condition)Cnd.where((String)"path", (String)"like", (Object)(Strings.sBlank((Object)m.getPath()) + "________")).and("type", "=", (Object)"data").asc("location").asc("path"));
        for (Sys_menu menu : menus) {
            for (Sys_menu bt : datas) {
                if (!menu.getPath().equals(bt.getPath().substring(0, bt.getPath().length() - 4))) continue;
                menu.setHasChildren(true);
                break;
            }
            list.add(menu);
        }
        return list;
    }

    @At
    @Ok(value="beetl:/platform/sys/menu/sort.html")
    @RequiresPermissions(value={"sys.manager.menu"})
    public void sort(HttpServletRequest req) {
        List list = this.sysMenuService.query((Condition)Cnd.orderBy().asc("location").asc("path"));
        ArrayList<Sys_menu> firstMenus = new ArrayList<Sys_menu>();
        HashMap<String, ArrayList<Sys_menu>> secondMenus = new HashMap<String, ArrayList<Sys_menu>>();
        for (Sys_menu menu : list) {
            if (menu.getPath().length() > 4) {
                ArrayList<Sys_menu> s = (ArrayList<Sys_menu>)secondMenus.get(StringUtil.getParentId(menu.getPath()));
                if (s == null) {
                    s = new ArrayList<Sys_menu>();
                }
                s.add(menu);
                secondMenus.put(StringUtil.getParentId(menu.getPath()), s);
                continue;
            }
            if (menu.getPath().length() != 4) continue;
            firstMenus.add(menu);
        }
        req.setAttribute("firstMenus", firstMenus);
        req.setAttribute("secondMenus", secondMenus);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.edit"})
    public Object sortDo(@Param(value="ids") String ids, HttpServletRequest req) {
        try {
            String[] menuIds = StringUtils.split((String)ids, (String)",");
            int i = 0;
            this.sysMenuService.execute(Sqls.create((String)"update sys_menu set location=0"));
            for (String s : menuIds) {
                if (Strings.isBlank((CharSequence)s)) continue;
                this.sysMenuService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)s));
                ++i;
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

