/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_msg;
import cn.wizzer.app.sys.modules.services.SysMsgService;
import cn.wizzer.app.sys.modules.services.SysMsgUserService;
import cn.wizzer.app.sys.modules.services.SysUserService;
import cn.wizzer.app.web.commons.ext.websocket.WkNotifyService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.OffsetPager;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.pager.Pager;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/msg"})
public class SysMsgController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysMsgService sysMsgService;
    @Inject
    @Reference
    private SysMsgUserService sysMsgUserService;
    @Inject
    @Reference
    private SysUserService sysUserService;
    @Inject
    private WkNotifyService wkNotifyService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/msg/index.html")
    @RequiresPermissions(value={"sys.manager.msg"})
    public void index() {
    }

    @At(value={"/data"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.msg"})
    public Object data(@Param(value="type") String type, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        if (Strings.isNotBlank((CharSequence)type) && !"all".equals(type)) {
            cnd.and("type", "=", (Object)type);
        }
        cnd.and("delFlag", "=", (Object)false);
        NutMap re = new NutMap();
        if (order != null && order.size() > 0) {
            for (DataTableOrder od : order) {
                DataTableColumn col = columns.get(od.getColumn());
                cnd.orderBy(Sqls.escapeSqlFieldValue((CharSequence)col.getData()).toString(), od.getDir());
            }
        }
        OffsetPager pager = new OffsetPager(start, length);
        re.put((Object)"recordsFiltered", (Object)this.sysMsgService.count((Condition)cnd));
        List list = this.sysMsgService.query((Condition)cnd, (Pager)pager);
        ArrayList<Map> mapList = new ArrayList<Map>();
        for (Sys_msg msg : list) {
            Map map = Lang.obj2map((Object)msg);
            map.put("all_num", this.sysMsgUserService.count((Condition)Cnd.where((String)"msgId", (String)"=", (Object)msg.getId())));
            map.put("unread_num", this.sysMsgUserService.count((Condition)Cnd.where((String)"msgId", (String)"=", (Object)msg.getId()).and("status", "=", (Object)0)));
            mapList.add(map);
        }
        re.put((Object)"data", mapList);
        re.put((Object)"draw", (Object)draw);
        re.put((Object)"recordsTotal", (Object)length);
        return re;
    }

    @At(value={"/add"})
    @Ok(value="beetl:/platform/sys/msg/add.html")
    @RequiresPermissions(value={"sys.manager.msg"})
    public void add() {
    }

    @At(value={"/addDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.msg.add"})
    @SLog(tag="\u7ad9\u5185\u6d88\u606f", msg="${args[0].title}")
    public Object addDo(@Param(value="..") Sys_msg sysMsg, @Param(value="users") String[] users, HttpServletRequest req) {
        try {
            sysMsg.setSendAt(Long.valueOf(Times.getTS()));
            sysMsg.setOpBy(StringUtil.getPlatformUid());
            Sys_msg sys_msg = this.sysMsgService.saveMsg(sysMsg, users);
            if (sys_msg != null) {
                this.wkNotifyService.notify(sys_msg, users);
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.msg.delete"})
    @SLog(tag="\u7ad9\u5185\u6d88\u606f", msg="${req.getAttribute('id')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            this.sysMsgService.deleteMsg(id);
            req.setAttribute("id", (Object)id);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/detail/?"})
    @Ok(value="beetl:/platform/sys/msg/detail.html")
    @RequiresPermissions(value={"sys.manager.msg"})
    public void detail(String id, HttpServletRequest req) {
        if (!Strings.isBlank((CharSequence)id)) {
            req.setAttribute("obj", this.sysMsgService.fetch(id));
        } else {
            req.setAttribute("obj", null);
        }
    }

    @At
    @Ok(value="beetl:/platform/sys/msg/selectUser.html")
    @RequiresPermissions(value={"sys.manager.msg"})
    public void selectUser(HttpServletRequest req) {
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.msg"})
    public Object selectData(@Param(value="name") String name, @Param(value="users") String users, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Object s;
        Object sql = "SELECT a.loginname,a.username,a.disabled,a.unitid,b.name as unitname FROM sys_user a,sys_unit b WHERE a.unitid=b.id ";
        if (!Strings.isBlank((CharSequence)name)) {
            sql = (String)sql + " and (a.loginname like '%" + name + "%' or a.username like '%" + name + "%') ";
        }
        if (!Strings.isBlank((CharSequence)users)) {
            s = StringUtils.split((String)users, (String)",");
            for (String u : s) {
                sql = (String)sql + " and a.loginname<>'" + (String)u + "'";
            }
        }
        s = sql;
        if (order != null && order.size() > 0) {
            for (DataTableOrder o : order) {
                DataTableColumn col = columns.get(o.getColumn());
                s = (String)s + " order by a." + Sqls.escapeSqlFieldValue((CharSequence)col.getData()).toString() + " " + o.getDir();
            }
        }
        return this.sysUserService.data(length, start, draw, Sqls.create((String)sql), Sqls.create((String)s));
    }

    @At(value={"/user/?/?"})
    @Ok(value="beetl:/platform/sys/msg/user.html")
    @RequiresPermissions(value={"sys.manager.msg"})
    public void allUser(String id, String status, HttpServletRequest req) {
        req.setAttribute("id", (Object)id);
        req.setAttribute("status", (Object)status);
    }

    @At(value={"/userData/?/?"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.msg"})
    public Object allUserData(String id, String status, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        String sql = "SELECT a.loginname,a.username,a.disabled,a.unitid,b.name as unitname,c.status,c.readat FROM sys_user a,sys_unit b,sys_msg_user c WHERE a.unitid=b.id \nand a.loginname=c.loginname and c.msgId='" + id + "' ";
        if (Strings.isNotBlank((CharSequence)status) && "unread".equals(status)) {
            sql = sql + " and c.status=0";
        }
        String s = sql;
        if (order != null && order.size() > 0) {
            for (DataTableOrder o : order) {
                DataTableColumn col = columns.get(o.getColumn());
                s = s + " order by a." + Sqls.escapeSqlFieldValue((CharSequence)col.getData()).toString() + " " + o.getDir();
            }
        }
        return this.sysUserService.data(length, start, draw, Sqls.create((String)sql), Sqls.create((String)s));
    }
}

