/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.cms;

import cn.wizzer.app.cms.modules.models.Cms_site;
import cn.wizzer.app.cms.modules.services.CmsSiteService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.adaptor.WhaleAdaptor;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/cms/site"})
public class CmsSiteController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private CmsSiteService cmsSiteService;

    @At(value={""})
    @Ok(value="beetl:/platform/cms/site/index.html")
    @RequiresPermissions(value={"cms.site.settings"})
    public Object index() {
        Cms_site site = (Cms_site)this.cmsSiteService.fetch("site");
        if (site == null) {
            site = new Cms_site();
            site.setId("site");
            site.setSite_name("Demo");
            site.setSite_domain("https://wizzer.cn");
            this.cmsSiteService.insert((Object)site);
        }
        return site;
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"cms.content.article"})
    public Object data(@Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        return this.cmsSiteService.data(length, start, draw, order, columns, cnd, null);
    }

    @At(value={"/add"})
    @Ok(value="beetl:/platform/cms/site/add.html")
    @RequiresPermissions(value={"cms.site.settings"})
    public void add() {
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/cms/site/edit.html")
    @RequiresPermissions(value={"cms.site.settings"})
    public Object edit(String id) {
        return this.cmsSiteService.fetch(id);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.site.settings.save"})
    @SLog(tag="\u6dfb\u52a0\u7ad9\u70b9", msg="${args[0].site_name}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object addDo(@Param(value="..") Cms_site site) {
        try {
            site.setOpAt(Long.valueOf(Times.getTS()));
            site.setOpBy(StringUtil.getPlatformUid());
            this.cmsSiteService.insert((Object)site);
            this.cmsSiteService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.site.settings.save"})
    @SLog(tag="\u4fee\u6539\u7ad9\u70b9", msg="${args[0].site_name}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object editDo(@Param(value="..") Cms_site site) {
        try {
            site.setOpAt(Long.valueOf(Times.getTS()));
            site.setOpBy(StringUtil.getPlatformUid());
            this.cmsSiteService.updateIgnoreNull((Object)site);
            this.cmsSiteService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

