/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_user;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxUserService;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import com.vdurmont.emoji.EmojiParser;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.LoopException;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/platform/wx/user"})
public class WxUserController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxUserService wxUserService;
    @Inject
    @Reference
    private WxConfigService wxConfigService;
    @Inject
    private WxService wxService;

    @At(value={"/index", "/index/?"})
    @Ok(value="beetl:/platform/wx/user/index.html")
    @RequiresPermissions(value={"wx.user.list"})
    public void index(String wxid, HttpServletRequest req) {
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxid = ((Wx_config)list.get(0)).getId();
        }
        req.setAttribute("wxid", (Object)wxid);
        req.setAttribute("wxList", (Object)list);
    }

    @At(value={"/data/", "/data/?"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.user.list"})
    public Object data(String wxid, @Param(value="nickname") String nickname, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        if (!Strings.isBlank((CharSequence)nickname)) {
            cnd.and("nickname", "like", (Object)("%" + nickname + "%"));
        }
        return this.wxUserService.data(length, start, draw, order, columns, cnd, null);
    }

    @At(value={"/down/", "/down/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.user.list.sync"})
    @SLog(tag="\u540c\u6b65\u5fae\u4fe1\u4f1a\u5458", msg="\u516c\u4f17\u53f7:${args[1].getAttribute('appname')}")
    public Object down(final String wxid, HttpServletRequest req) {
        try {
            Wx_config config = (Wx_config)this.wxConfigService.fetch(wxid);
            req.setAttribute("appname", (Object)config.getAppname());
            final WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            wxApi2.user_get((Each)new Each<String>(){

                public void invoke(int index, String _ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                    WxResp resp = wxApi2.user_info(_ele, "zh_CN");
                    log.info((Object)Json.toJson((Object)resp));
                    log.debug((Object)(index + " : " + _ele + ", nickname: " + resp.user().getNickname()));
                    Wx_user usr = (Wx_user)Json.fromJson(Wx_user.class, (CharSequence)Json.toJson((Object)resp.user()));
                    usr.setOpAt(Long.valueOf(Times.getTS()));
                    usr.setNickname(EmojiParser.parseToAliases((String)usr.getNickname(), (EmojiParser.FitzpatrickAction)EmojiParser.FitzpatrickAction.REMOVE));
                    usr.setSubscribeAt(Long.valueOf(resp.user().getSubscribe_time()));
                    usr.setWxid(wxid);
                    if (WxUserController.this.wxUserService.fetch((Condition)Cnd.where((String)"wxid", (String)"=", (Object)wxid).and("openid", "=", (Object)usr.getOpenid())) == null) {
                        WxUserController.this.wxUserService.insert((Object)usr);
                    }
                }
            });
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"system.error");
        }
    }
}

