/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_config;
import cn.wizzer.app.sys.modules.services.SysConfigService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.integration.jedis.pubsub.PubSubService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/conf"})
public class SysConfController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysConfigService sysConfigService;
    @Inject
    private PubSubService pubSubService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/conf/index.html")
    @RequiresPermissions(value={"sys.manager.conf"})
    public void index() {
    }

    @At
    @Ok(value="beetl:/platform/sys/conf/add.html")
    @RequiresPermissions(value={"sys.manager.conf"})
    public void add() {
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.conf.add"})
    @SLog(tag="\u6dfb\u52a0\u53c2\u6570", msg="${args[0].configKey}:${args[0].configValue}")
    public Object addDo(@Param(value="..") Sys_config conf) {
        try {
            conf.setOpBy(StringUtil.getPlatformUid());
            if (this.sysConfigService.insert((Object)conf) != null) {
                this.pubSubService.fire("nutzwk:web:platform", "sys_config");
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/sys/conf/edit.html")
    @RequiresPermissions(value={"sys.manager.conf"})
    public Object edit(String id) {
        return this.sysConfigService.fetch(id);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.conf.edit"})
    @SLog(tag="\u4fee\u6539\u53c2\u6570", msg="${args[0].configKey}:${args[0].configValue}")
    public Object editDo(@Param(value="..") Sys_config conf) {
        try {
            if (this.sysConfigService.updateIgnoreNull((Object)conf) > 0) {
                this.pubSubService.fire("nutzwk:web:platform", "sys_config");
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.conf.delete"})
    @SLog(tag="\u5220\u9664\u53c2\u6570", msg="\u53c2\u6570:${args[0]}")
    public Object delete(String configKey) {
        try {
            if (Strings.sBlank((Object)configKey).startsWith("App")) {
                return Result.error((String)"\u7cfb\u7edf\u53c2\u6570\u4e0d\u53ef\u5220\u9664");
            }
            if (this.sysConfigService.delete(configKey) > 0) {
                this.pubSubService.fire("nutzwk:web:platform", "sys_config");
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.conf"})
    public Object data(@Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        return this.sysConfigService.data(length, start, draw, order, columns, cnd, null);
    }
}

