/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.ext.websocket;

import cn.wizzer.app.sys.modules.models.Sys_msg;
import cn.wizzer.app.sys.modules.models.Sys_msg_user;
import cn.wizzer.app.sys.modules.services.SysMsgService;
import cn.wizzer.app.sys.modules.services.SysMsgUserService;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nutz.aop.interceptor.async.Async;
import org.nutz.integration.jedis.RedisService;
import org.nutz.integration.jedis.pubsub.PubSubService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

@IocBean
public class WkNotifyService {
    private static final Log log = Logs.get();
    @Inject
    private PubSubService pubSubService;
    @Inject
    @Reference
    private SysMsgService sysMsgService;
    @Inject
    @Reference
    private SysMsgUserService sysMsgUserService;
    @Inject
    private RedisService redisService;
    private static NutMap typeMap = NutMap.NEW().addv("system", (Object)"\u7cfb\u7edf\u6d88\u606f").addv("user", (Object)"\u7528\u6237\u6d88\u606f");

    @Async
    public void notify(Sys_msg innerMsg, String[] rooms) {
        String url = "/platform/sys/msg/user/all";
        if (Strings.isNotBlank((CharSequence)innerMsg.getUrl())) {
            url = innerMsg.getUrl();
        }
        NutMap map = new NutMap();
        map.put((Object)"action", (Object)"notify");
        map.put((Object)"title", (Object)"\u60a8\u6709\u65b0\u7684\u6d88\u606f");
        map.put((Object)"body", (Object)innerMsg.getTitle());
        map.put((Object)"url", (Object)url);
        String msg = Json.toJson((Object)map, (JsonFormat)JsonFormat.compact());
        if ("system".equals(innerMsg.getType())) {
            ScanParams match = new ScanParams().match("wsroom:*");
            ScanResult scan = null;
            do {
                scan = this.redisService.scan(scan == null ? ScanParams.SCAN_POINTER_START : scan.getStringCursor(), match);
                for (String room : scan.getResult()) {
                    this.pubSubService.fire(room, msg);
                }
            } while (!scan.isCompleteIteration());
        } else if ("user".equals(innerMsg.getType())) {
            for (String room : rooms) {
                ScanParams match = new ScanParams().match("wsroom:" + room + ":*");
                ScanResult scan = null;
                do {
                    scan = this.redisService.scan(scan == null ? ScanParams.SCAN_POINTER_START : scan.getStringCursor(), match);
                    for (String key : scan.getResult()) {
                        this.pubSubService.fire(key, msg);
                    }
                } while (!scan.isCompleteIteration());
            }
        }
    }

    @Async
    public void innerMsg(String room, int size, List<NutMap> list) {
        NutMap map = new NutMap();
        map.put((Object)"action", (Object)"innerMsg");
        map.put((Object)"size", (Object)size);
        map.put((Object)"list", list);
        String msg = Json.toJson((Object)map, (JsonFormat)JsonFormat.compact());
        log.debug((Object)("msg::::" + msg));
        ScanParams match = new ScanParams().match("wsroom:" + room + ":*");
        ScanResult scan = null;
        do {
            scan = this.redisService.scan(scan == null ? ScanParams.SCAN_POINTER_START : scan.getStringCursor(), match);
            for (String key : scan.getResult()) {
                this.pubSubService.fire(key, msg);
            }
        } while (!scan.isCompleteIteration());
    }

    @Async
    public void getMsg(String loginname) {
        try {
            int size = this.sysMsgUserService.getUnreadNum(loginname);
            List list = this.sysMsgUserService.getUnreadList(loginname, 1, 5);
            ArrayList<NutMap> mapList = new ArrayList<NutMap>();
            for (Sys_msg_user msgUser : list) {
                String url = "/platform/sys/msg/user/all/detail/" + msgUser.getMsgId();
                if (Strings.isNotBlank((CharSequence)msgUser.getMsg().getUrl())) {
                    url = msgUser.getMsg().getUrl();
                }
                mapList.add(NutMap.NEW().addv("msgId", (Object)msgUser.getMsgId()).addv("type", (Object)typeMap.getString(msgUser.getMsg().getType())).addv("title", (Object)msgUser.getMsg().getTitle()).addv("url", (Object)url).addv("time", (Object)Times.format((String)"yyyy-MM-dd HH:mm", (Date)Times.D((long)(1000L * msgUser.getMsg().getSendAt())))));
            }
            this.innerMsg(loginname, size, mapList);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Async
    public void offline(String loginname, String httpSessionId) {
        NutMap map = new NutMap();
        map.put((Object)"action", (Object)"offline");
        map.put((Object)"title", (Object)"");
        map.put((Object)"body", (Object)"");
        map.put((Object)"url", (Object)"");
        String msg = Json.toJson((Object)map, (JsonFormat)JsonFormat.compact());
        try {
            this.pubSubService.fire("wsroom:" + loginname + ":" + httpSessionId, msg);
            this.redisService.expire("wsroom:" + loginname + ":" + httpSessionId, 180);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Async
    public void offlineNoMsg(String loginname, String httpSessionId) {
        try {
            this.redisService.expire("wsroom:" + loginname + ":" + httpSessionId, 180);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

