/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.ext.websocket;

import cn.wizzer.app.web.commons.ext.websocket.WkJedisRoomProvider;
import cn.wizzer.app.web.commons.ext.websocket.WkWsHandler;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.nutz.integration.jedis.JedisAgent;
import org.nutz.integration.jedis.pubsub.PubSub;
import org.nutz.integration.jedis.pubsub.PubSubService;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.mvc.websocket.AbstractWsEndpoint;
import org.nutz.plugins.mvc.websocket.NutWsConfigurator;
import org.nutz.plugins.mvc.websocket.WsHandler;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

@ServerEndpoint(value="/websocket", configurator=NutWsConfigurator.class)
@IocBean(create="init")
public class WkWebSocket
extends AbstractWsEndpoint
implements PubSub {
    protected static final Log log = Logs.get();
    @Inject
    protected PubSubService pubSubService;
    @Inject
    protected JedisAgent jedisAgent;
    @Inject(value="refer:$ioc")
    protected Ioc ioc;

    public WsHandler createHandler(Session session, EndpointConfig config) {
        return (WsHandler)this.ioc.get(WkWsHandler.class);
    }

    public void init() {
        this.roomPrefix = "wsroom:";
        this.roomProvider = new WkJedisRoomProvider(this.jedisAgent);
        try (Jedis jedis = this.jedisAgent.getResource();){
            ScanParams match = new ScanParams().match(this.roomPrefix + "*");
            ScanResult scan = null;
            do {
                scan = jedis.scan(scan == null ? ScanParams.SCAN_POINTER_START : scan.getStringCursor(), match);
                block17: for (String key : scan.getResult()) {
                    switch (jedis.type(key)) {
                        case "none": 
                        case "set": {
                            continue block17;
                        }
                    }
                    jedis.del(key);
                }
            } while (!scan.isCompleteIteration());
        }
        this.pubSubService.reg(this.roomPrefix + "*", (PubSub)this);
    }

    public void onMessage(String channel, String message) {
        if (log.isDebugEnabled()) {
            log.debugf("GET PubSub channel=%s msg=%s", new Object[]{channel, message});
        }
        this.each(channel, (index, session, length) -> session.getAsyncRemote().sendText(message));
    }
}

