/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_menu;
import cn.wizzer.app.sys.modules.services.SysMenuService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/menu"})
public class SysMenuController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysMenuService sysMenuService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/menu/index.html")
    @RequiresPermissions(value={"sys.manager.menu"})
    public void index(HttpServletRequest req) {
    }

    @At(value={"/child"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object child(@Param(value="pid") String pid, HttpServletRequest req) {
        List list = new ArrayList();
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        Cnd cnd = Cnd.NEW();
        if (Strings.isBlank((CharSequence)pid)) {
            cnd.and((SqlExpression)Cnd.exps((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null));
        } else {
            cnd.and("parentId", "=", (Object)pid);
        }
        cnd.asc("location").asc("path");
        list = this.sysMenuService.query((Condition)cnd);
        for (Sys_menu menu : list) {
            if (this.sysMenuService.count((Condition)Cnd.where((String)"parentId", (String)"=", (Object)menu.getId())) > 0) {
                menu.setHasChildren(true);
            }
            NutMap map = Lang.obj2nutmap((Object)menu);
            map.addv("expanded", (Object)false);
            map.addv("children", new ArrayList());
            treeList.add(map);
        }
        return Result.success().addData(treeList);
    }

    @At(value={"/tree"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object tree(@Param(value="pid") String pid, HttpServletRequest req) {
        try {
            ArrayList<NutMap> treeList = new ArrayList<NutMap>();
            if (Strings.isBlank((CharSequence)pid)) {
                NutMap root = NutMap.NEW().addv("value", (Object)"root").addv("label", (Object)"\u4e0d\u9009\u62e9\u83dc\u5355");
                treeList.add(root);
            }
            Cnd cnd = Cnd.NEW();
            if (Strings.isBlank((CharSequence)pid)) {
                cnd.and((SqlExpression)Cnd.exps((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null));
            } else {
                cnd.and("parentId", "=", (Object)pid);
            }
            cnd.and("type", "=", (Object)"menu");
            cnd.asc("location").asc("path");
            List list = this.sysMenuService.query((Condition)cnd);
            for (Sys_menu menu : list) {
                NutMap map = NutMap.NEW().addv("value", (Object)menu.getId()).addv("label", (Object)menu.getName());
                if (menu.isHasChildren()) {
                    map.addv("children", new ArrayList());
                }
                treeList.add(map);
            }
            return Result.success().addData(treeList);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.add"})
    @SLog(tag="\u65b0\u5efa\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object addDo(@Param(value="..") NutMap nutMap, HttpServletRequest req) {
        try {
            Sys_menu sysMenu = (Sys_menu)nutMap.getAs("menu", Sys_menu.class);
            List buttons = Json.fromJsonAsList(NutMap.class, (CharSequence)nutMap.getString("buttons"));
            int num = this.sysMenuService.count((Condition)Cnd.where((String)"permission", (String)"=", (Object)sysMenu.getPermission().trim()));
            if (num > 0) {
                return Result.error((String)"sys.role.code");
            }
            for (NutMap map : buttons) {
                num = this.sysMenuService.count((Condition)Cnd.where((String)"permission", (String)"=", (Object)map.getString("permission", "").trim()));
                if (num <= 0) continue;
                return Result.error((String)"sys.role.code");
            }
            sysMenu.setHasChildren(false);
            sysMenu.setShowit(true);
            sysMenu.setOpBy(StringUtil.getPlatformUid());
            this.sysMenuService.save(sysMenu, sysMenu.getParentId(), buttons);
            req.setAttribute("name", (Object)sysMenu.getName());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/editMenu/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu"})
    public Object editMenu(String id, HttpServletRequest req) {
        try {
            Sys_menu menu = (Sys_menu)this.sysMenuService.fetch(id);
            NutMap map = Lang.obj2nutmap((Object)menu);
            map.put((Object)"parentName", (Object)"\u65e0");
            map.put((Object)"children", (Object)"false");
            if (Strings.isNotBlank((CharSequence)menu.getParentId())) {
                map.put((Object)"parentName", (Object)((Sys_menu)this.sysMenuService.fetch(menu.getParentId())).getName());
            }
            List list = this.sysMenuService.query((Condition)Cnd.where((String)"parentId", (String)"=", (Object)id).and("type", "=", (Object)"data").asc("location").asc("path"));
            ArrayList<NutMap> buttons = new ArrayList<NutMap>();
            if (list != null && list.size() > 0) {
                map.put((Object)"children", (Object)"true");
                for (Sys_menu m : list) {
                    buttons.add(NutMap.NEW().addv("key", (Object)m.getId()).addv("name", (Object)m.getName()).addv("permission", (Object)m.getPermission()));
                }
            }
            map.put((Object)"buttons", buttons);
            return Result.success().addData((Object)map);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.edit"})
    @SLog(tag="\u4fee\u6539\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object editMenuDo(@Param(value="..") NutMap nutMap, HttpServletRequest req) {
        try {
            Sys_menu sysMenu = (Sys_menu)nutMap.getAs("menu", Sys_menu.class);
            List buttons = Json.fromJsonAsList(NutMap.class, (CharSequence)nutMap.getString("buttons"));
            int num = this.sysMenuService.count((Condition)Cnd.where((String)"permission", (String)"=", (Object)sysMenu.getPermission().trim()).and("id", "<>", (Object)sysMenu.getId()));
            if (num > 0) {
                return Result.error((String)"sys.role.code");
            }
            for (NutMap map : buttons) {
                num = this.sysMenuService.count((Condition)Cnd.where((String)"permission", (String)"=", (Object)map.getString("permission", "").trim()).and("id", "<>", (Object)map.getString("key", "")));
                if (num <= 0) continue;
                return Result.error((String)"sys.role.code");
            }
            sysMenu.setHasChildren(false);
            sysMenu.setShowit(true);
            sysMenu.setOpBy(StringUtil.getPlatformUid());
            this.sysMenuService.edit(sysMenu, sysMenu.getParentId(), buttons);
            req.setAttribute("name", (Object)sysMenu.getName());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/editData/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu"})
    public Object editData(String id, HttpServletRequest req) {
        try {
            return Result.success().addData(this.sysMenuService.fetch(id));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.edit"})
    @SLog(tag="\u4fee\u6539\u6743\u9650", msg="\u6743\u9650\u540d\u79f0:${args[0].name}")
    public Object editDataDo(@Param(value="..") Sys_menu menu, HttpServletRequest req) {
        try {
            int num = this.sysMenuService.count((Condition)Cnd.where((String)"permission", (String)"=", (Object)menu.getPermission().trim()).and("id", "<>", (Object)menu.getId()));
            if (num > 0) {
                return Result.error((String)"sys.role.code");
            }
            this.sysMenuService.updateIgnoreNull((Object)menu);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.delete"})
    @SLog(tag="\u5220\u9664\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            Sys_menu menu = (Sys_menu)this.sysMenuService.fetch(id);
            req.setAttribute("name", (Object)menu.getName());
            if (menu.getPath().startsWith("0001")) {
                return Result.error((String)"system.not.allow");
            }
            this.sysMenuService.deleteAndChild(menu);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.edit"})
    @SLog(tag="\u542f\u7528\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object enable(String menuId, HttpServletRequest req) {
        try {
            req.setAttribute("name", (Object)((Sys_menu)this.sysMenuService.fetch(menuId)).getName());
            this.sysMenuService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)menuId));
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.edit"})
    @SLog(tag="\u7981\u7528\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object disable(String menuId, HttpServletRequest req) {
        try {
            req.setAttribute("name", (Object)((Sys_menu)this.sysMenuService.fetch(menuId)).getName());
            this.sysMenuService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)menuId));
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/menuAll"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu"})
    public Object menuAll(HttpServletRequest req) {
        try {
            List list = this.sysMenuService.query((Condition)Cnd.where((String)"type", (String)"=", (Object)"menu").asc("location").asc("path"));
            NutMap menuMap = NutMap.NEW();
            for (Sys_menu unit : list) {
                ArrayList<Sys_menu> list1 = menuMap.getList(unit.getParentId(), Sys_menu.class);
                if (list1 == null) {
                    list1 = new ArrayList<Sys_menu>();
                }
                list1.add(unit);
                menuMap.put((Object)unit.getParentId(), list1);
            }
            return Result.success().addData(this.getTree(menuMap, ""));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    private List<NutMap> getTree(NutMap menuMap, String pid) {
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        List subList = menuMap.getList(pid, Sys_menu.class);
        for (Sys_menu menu : subList) {
            NutMap map = Lang.obj2nutmap((Object)menu);
            map.put((Object)"label", (Object)menu.getName());
            if (menu.isHasChildren() || menuMap.get((Object)menu.getId()) != null) {
                map.put((Object)"children", this.getTree(menuMap, menu.getId()));
            }
            treeList.add(map);
        }
        return treeList;
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.menu.edit"})
    public Object sortDo(@Param(value="ids") String ids, HttpServletRequest req) {
        try {
            String[] menuIds = StringUtils.split((String)ids, (String)",");
            int i = 0;
            this.sysMenuService.execute(Sqls.create((String)"update sys_menu set location=0"));
            for (String s : menuIds) {
                if (Strings.isBlank((CharSequence)s)) continue;
                this.sysMenuService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)s));
                ++i;
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

