/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_msg;
import cn.wizzer.app.sys.modules.services.SysMsgService;
import cn.wizzer.app.sys.modules.services.SysMsgUserService;
import cn.wizzer.app.sys.modules.services.SysUserService;
import cn.wizzer.app.web.commons.ext.websocket.WkNotifyService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.Pagination;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/msg"})
public class SysMsgController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysMsgService sysMsgService;
    @Inject
    @Reference
    private SysMsgUserService sysMsgUserService;
    @Inject
    @Reference
    private SysUserService sysUserService;
    @Inject
    private WkNotifyService wkNotifyService;

    @At(value={"/", "/list/?"})
    @Ok(value="beetl:/platform/sys/msg/index.html")
    @RequiresPermissions(value={"sys.manager.msg"})
    public void index(String type, HttpServletRequest req) {
        req.setAttribute("type", (Object)(Strings.isBlank((CharSequence)type) ? "all" : type));
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.msg"})
    public Object data(@Param(value="searchType") String searchType, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (Strings.isNotBlank((CharSequence)searchType) && !"all".equals(searchType)) {
                cnd.and("type", "=", (Object)searchType);
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            ArrayList<Map> mapList = new ArrayList<Map>();
            Pagination pagination = this.sysMsgService.listPage(Integer.valueOf(pageNumber), pageSize, (Condition)cnd);
            for (Object msg : pagination.getList()) {
                Map map = Lang.obj2map(msg);
                map.put("all_num", this.sysMsgUserService.count((Condition)Cnd.where((String)"msgId", (String)"=", (Object)map.getOrDefault("id", ""))));
                map.put("unread_num", this.sysMsgUserService.count((Condition)Cnd.where((String)"msgId", (String)"=", (Object)map.getOrDefault("id", "")).and("status", "=", (Object)0)));
                mapList.add(map);
            }
            pagination.setList(mapList);
            return Result.success().addData((Object)pagination);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.msg"})
    public Object user_view_data(@Param(value="type") String type, @Param(value="id") String id, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            String sql = "SELECT a.loginname,a.username,a.mobile,a.email,a.disabled,a.unitid,b.name as unitname,c.status,c.readat FROM sys_user a,sys_unit b,sys_msg_user c WHERE a.unitid=b.id \nand a.loginname=c.loginname and c.msgId='" + id + "' ";
            if (Strings.isNotBlank((CharSequence)type) && "unread".equals(type)) {
                sql = sql + " and c.status=0 ";
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                sql = sql + " order by a." + pageOrderName + " " + PageUtil.getOrder(pageOrderBy);
            }
            return Result.success().addData((Object)this.sysMsgService.listPage(Integer.valueOf(pageNumber), pageSize, Sqls.create((String)sql)));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/addDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.msg.add"})
    @SLog(tag="\u7ad9\u5185\u6d88\u606f", msg="${args[0].title}")
    public Object addDo(@Param(value="..") NutMap nutMap, HttpServletRequest req) {
        try {
            Sys_msg sysMsg = (Sys_msg)nutMap.getAs("msg", Sys_msg.class);
            sysMsg.setNote(nutMap.getString("note", ""));
            sysMsg.setSendAt(Long.valueOf(Times.getTS()));
            sysMsg.setOpBy(StringUtil.getPlatformUid());
            String[] users = StringUtils.split((String)nutMap.getString("users", ""), (String)",");
            Sys_msg sys_msg = this.sysMsgService.saveMsg(sysMsg, users);
            if (sys_msg != null) {
                this.wkNotifyService.notify(sys_msg, users);
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:{locked:'password|salt',ignoreNull:false}")
    @RequiresPermissions(value={"sys.manager.user"})
    public Object user_data(@Param(value="searchUnit") String searchUnit, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (Strings.isNotBlank((CharSequence)searchName) && Strings.isNotBlank((CharSequence)searchKeyword)) {
                cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.sysUserService.listPageLinks(Integer.valueOf(pageNumber), pageSize, (Condition)cnd, "unit"));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.msg.delete"})
    @SLog(tag="\u7ad9\u5185\u6d88\u606f", msg="\u7ad9\u5185\u4fe1\u6807\u9898:${req.getAttribute('title')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            req.setAttribute("title", (Object)((Sys_msg)this.sysMsgService.fetch(id)).getTitle());
            this.sysMsgService.deleteMsg(id);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

