/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.cms.modules.services.CmsArticleService;
import cn.wizzer.app.cms.modules.services.CmsChannelService;
import cn.wizzer.app.web.commons.base.Globals;
import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.DateUtil;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_reply_news;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxReplyNewsService;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Files;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.adaptor.WhaleAdaptor;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.impl.AdaptorErrorContext;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadAdaptor;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/platform/wx/reply/news"})
public class WxReplyNewsController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxReplyNewsService wxReplyNewsService;
    @Inject
    @Reference
    private WxConfigService wxConfigService;
    @Inject
    @Reference
    private CmsChannelService cmsChannelService;
    @Inject
    @Reference
    private CmsArticleService cmsArticleService;
    @Inject
    private WxService wxService;

    @At(value={"/", "/index/?"})
    @Ok(value="beetl:/platform/wx/reply/news/index.html")
    @RequiresPermissions(value={"wx.reply"})
    public void index(String wxid, HttpServletRequest req) {
        Wx_config wxConfig = null;
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)list.get(0);
        }
        if (Strings.isNotBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)this.wxConfigService.fetch(wxid);
        }
        req.setAttribute("wxConfig", wxConfig);
        req.setAttribute("wxList", (Object)list);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.news.add"})
    @SLog(tag="\u6dfb\u52a0\u56de\u590d\u56fe\u6587", msg="\u56fe\u6587\u6807\u9898:${args[0].title}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object addDo(@Param(value="..") Wx_reply_news news, HttpServletRequest req) {
        try {
            news.setOpBy(StringUtil.getPlatformUid());
            this.wxReplyNewsService.insert((Object)news);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.news.edit"})
    public Object edit(String id) {
        try {
            return Result.success().addData(this.wxReplyNewsService.fetch(id));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.news.edit"})
    @SLog(tag="\u4fee\u6539\u56de\u590d\u56fe\u6587", msg="\u56fe\u6587\u6807\u9898:${args[0].title}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object editDo(@Param(value="..") Wx_reply_news news, HttpServletRequest req) {
        try {
            this.wxReplyNewsService.updateIgnoreNull((Object)news);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.news.delete"})
    @SLog(tag="\u5220\u9664\u56de\u590d\u56fe\u6587", msg="\u56fe\u6587\u6807\u9898:${args[1].getAttribute('title')}}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            req.setAttribute("title", (Object)((Wx_reply_news)this.wxReplyNewsService.fetch(id)).getTitle());
            this.wxReplyNewsService.delete(id);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.news.delete"})
    @SLog(tag="\u5220\u9664\u56de\u590d\u56fe\u6587", msg="ID:${args[0]}")
    public Object deletes(@Param(value="ids") String id, HttpServletRequest req) {
        try {
            this.wxReplyNewsService.delete(StringUtils.split((String)id, (String)","));
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.reply"})
    public Object data(@Param(value="wxid") String wxid, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (Strings.isNotBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        if (!Strings.isBlank((CharSequence)searchName) && !Strings.isBlank((CharSequence)searchKeyword)) {
            cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
        }
        if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData((Object)this.wxReplyNewsService.listPage(Integer.valueOf(pageNumber), pageSize, (Condition)cnd));
    }

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:imageUpload"})
    @POST
    @At(value={"/uploadImage/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply"})
    public Object uploadImage(String wxid, @Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            WxResp resp = wxApi2.add_material("image", tf.getFile());
            if (resp.errcode() != 0) {
                return Result.error((String)resp.errmsg());
            }
            String uri = "/file/" + DateUtil.format(new Date(), "yyyyMMdd") + "/" + R.UU32() + tf.getSubmittedFileName().substring(tf.getSubmittedFileName().indexOf("."));
            String f = Globals.AppUploadPath + uri;
            Files.write((File)new File(f), (Object)tf.getInputStream());
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("id", resp.get((Object)"media_id")).addv("picurl", (Object)Strings.sNull((Object)resp.get((Object)"url")).replace("http://", "https://")).addv("picurl2", (Object)(Globals.AppUploadBase + uri)));
        }
        catch (Exception e) {
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            return Result.error((String)"\u56fe\u7247\u683c\u5f0f\u9519\u8bef");
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.reply"})
    public Object channel_data(@Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)searchName) && !Strings.isBlank((CharSequence)searchKeyword)) {
            cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
        }
        if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData((Object)this.cmsChannelService.listPage(Integer.valueOf(pageNumber), pageSize, (Condition)cnd));
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.reply"})
    public Object article_data(@Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)searchName) && !Strings.isBlank((CharSequence)searchKeyword)) {
            cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
        }
        if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData((Object)this.cmsArticleService.listPage(Integer.valueOf(pageNumber), pageSize, (Condition)cnd));
    }
}

