package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.app.wx.modules.models.Wx_test;
import cn.wizzer.app.wx.modules.services.WxTestService;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@IocBean
@At("/platform/wx/test")
public class WxTestController{
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxTestService wxTestService;

    @At("")
    @Ok("beetl:/platform/wx/test/index.html")
    @RequiresPermissions("platform.wx.test")
    public void index() {
    }

    @At("/data")
    @Ok("json:full")
    @RequiresPermissions("platform.wx.test")
    public Object data(@Param("searchName") String searchName, @Param("searchKeyword") String searchKeyword, @Param("pageNumber") int pageNumber, @Param("pageSize") int pageSize, @Param("pageOrderName") String pageOrderName, @Param("pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank(searchName) && !Strings.isBlank(searchKeyword)) {
            cnd.and(searchName, "like", "%" + searchKeyword + "%");
        }
        if (Strings.isNotBlank(pageOrderName) && Strings.isNotBlank(pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData(wxTestService.listPage(pageNumber, pageSize, cnd));
    }


    @At("/addDo")
    @Ok("json")
    @RequiresPermissions("platform.wx.test.add")
    @SLog(tag = "Wx_test", msg = "${args[0].id}")
    public Object addDo(@Param("..")Wx_test wxTest, HttpServletRequest req) {
		try {
            wxTest.setOpBy(StringUtil.getPlatformUid());
			wxTestService.insert(wxTest);
			return Result.success();
		} catch (Exception e) {
			return Result.error();
		}
    }

    @At("/edit/?")
    @Ok("json")
    @RequiresPermissions("platform.wx.test")
    public Object edit(String id,HttpServletRequest req) {
        try {
            return Result.success().addData(wxTestService.fetch(id));
        } catch (Exception e) {
            return Result.error();
        }
    }

    @At("/editDo")
    @Ok("json")
    @RequiresPermissions("platform.wx.test.edit")
    @SLog(tag = "Wx_test", msg = "${args[0].id}")
    public Object editDo(@Param("..")Wx_test wxTest, HttpServletRequest req) {
		try {
            wxTest.setOpBy(StringUtil.getPlatformUid());
			wxTest.setOpAt(Times.getTS());
			wxTestService.updateIgnoreNull(wxTest);
			return Result.success();
		} catch (Exception e) {
			return Result.error();
		}
    }

    @At({"/delete/?", "/delete"})
    @Ok("json")
    @RequiresPermissions("platform.wx.test.delete")
    @SLog(tag = "Wx_test", msg = "${req.getAttribute('id')}")
    public Object delete(String id, @Param("ids")  String[] ids, HttpServletRequest req) {
		try {
			if(ids!=null&&ids.length>0){
				wxTestService.delete(ids);
    			req.setAttribute("id", org.apache.shiro.util.StringUtils.toString(ids));
			}else{
				wxTestService.delete(id);
    			req.setAttribute("id", id);
			}
            return Result.success();
        } catch (Exception e) {
            return Result.error();
        }
    }
}
