/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.framework.base.Result;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.boot.starter.logback.exts.loglevel.LoglevelCommand;
import org.nutz.boot.starter.logback.exts.loglevel.LoglevelService;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/monitor"})
public class SysMonitorController {
    private static final Log log = Logs.get();
    @Inject
    private LoglevelService loglevelService;
    @Inject
    private RedisService redisService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/monitor/index.html")
    @RequiresPermissions(value={"sys.operation.monitor"})
    public void index() {
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.operation.monitor"})
    public Object data() {
        try {
            return Result.success().addData((Object)this.loglevelService.getData());
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.monitor.loglevel"})
    public Object loglevel(@Param(value="action") String action, @Param(value="name") String name, @Param(value="processId") String processId, @Param(value="loglevel") String loglevel) {
        try {
            LoglevelCommand loglevelCommand = new LoglevelCommand();
            loglevelCommand.setAction(action);
            loglevelCommand.setLevel(loglevel);
            if ("processId".equals(action)) {
                loglevelCommand.setProcessId(processId);
            }
            loglevelCommand.setName(name);
            this.loglevelService.changeLoglevel(loglevelCommand);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

