/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_menu;
import cn.wizzer.app.sys.modules.models.Sys_unit;
import cn.wizzer.app.sys.modules.models.Sys_user;
import cn.wizzer.app.sys.modules.services.SysMenuService;
import cn.wizzer.app.sys.modules.services.SysUnitService;
import cn.wizzer.app.sys.modules.services.SysUserService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.ShiroUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.integration.json4excel.J4E;
import org.nutz.integration.json4excel.J4EColumn;
import org.nutz.integration.json4excel.J4EConf;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/user"})
public class SysUserController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysUserService sysUserService;
    @Inject
    @Reference
    private SysMenuService sysMenuService;
    @Inject
    @Reference
    private SysUnitService sysUnitService;
    @Inject
    private ShiroUtil shiroUtil;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/user/index.html")
    @RequiresPermissions(value={"sys.manager.user"})
    public void index() {
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.add"})
    @SLog(tag="\u65b0\u5efa\u7528\u6237", msg="\u7528\u6237\u540d:${args[0].loginname}")
    public Object addDo(@Param(value="..") Sys_user user, HttpServletRequest req) {
        try {
            int num;
            if (Strings.isNotBlank((CharSequence)user.getLoginname()) && (num = this.sysUserService.count((Condition)Cnd.where((String)"loginname", (String)"=", (Object)Strings.trim((CharSequence)user.getLoginname())))) > 0) {
                return Result.error((String)"\u7528\u6237\u540d\u5df2\u5b58\u5728!");
            }
            if (Strings.isNotBlank((CharSequence)user.getMobile()) && (num = this.sysUserService.count((Condition)Cnd.where((String)"mobile", (String)"=", (Object)Strings.trim((CharSequence)user.getMobile())))) > 0) {
                return Result.error((String)"\u624b\u673a\u53f7\u5df2\u5b58\u5728!");
            }
            if (Strings.isNotBlank((CharSequence)user.getEmail()) && (num = this.sysUserService.count((Condition)Cnd.where((String)"email", (String)"=", (Object)Strings.trim((CharSequence)user.getEmail())))) > 0) {
                return Result.error((String)"\u90ae\u7bb1\u5df2\u5b58\u5728!");
            }
            String salt = R.UU32();
            user.setSalt(salt);
            user.setPassword(new Sha256Hash((Object)user.getPassword(), (Object)ByteSource.Util.bytes((String)salt), 1024).toHex());
            user.setLoginPjax(true);
            user.setLoginCount(Integer.valueOf(0));
            user.setOpBy(StringUtil.getPlatformUid());
            this.sysUserService.insert((Object)user);
            this.sysUserService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user"})
    public Object edit(String id) {
        try {
            return Result.success().addData(this.sysUserService.fetchLinks(this.sysUserService.fetch(id), "unit"));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.edit"})
    @SLog(tag="\u4fee\u6539\u7528\u6237", msg="\u7528\u6237\u540d:${args[1]}->${args[0].loginname}")
    public Object editDo(@Param(value="..") Sys_user user, HttpServletRequest req) {
        try {
            user.setOpBy(StringUtil.getPlatformUid());
            user.setOpAt(Long.valueOf(Times.getTS()));
            this.sysUserService.updateIgnoreNull((Object)user);
            this.sysUserService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/resetPwd/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.edit"})
    @SLog(tag="\u91cd\u7f6e\u5bc6\u7801", msg="\u7528\u6237\u540d:${args[1].getAttribute('loginname')}")
    public Object resetPwd(String id, HttpServletRequest req) {
        try {
            Sys_user user = (Sys_user)this.sysUserService.fetch(id);
            String salt = R.UU32();
            String pwd = R.captchaNumber((int)6);
            String hashedPasswordBase64 = new Sha256Hash((Object)pwd, (Object)ByteSource.Util.bytes((String)salt), 1024).toHex();
            this.sysUserService.update(Chain.make((String)"salt", (Object)salt).add("password", (Object)hashedPasswordBase64), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            this.sysUserService.clearCache();
            req.setAttribute("loginname", (Object)user.getLoginname());
            return Result.success().addData((Object)pwd);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.delete"})
    @SLog(tag="\u5220\u9664\u7528\u6237", msg="\u7528\u6237\u540d:${args[1].getAttribute('loginname')}")
    public Object delete(String userId, HttpServletRequest req) {
        try {
            Sys_user user = (Sys_user)this.sysUserService.fetch(userId);
            if ("superadmin".equals(user.getLoginname())) {
                return Result.error((String)"system.not.allow");
            }
            this.sysUserService.deleteById(userId);
            this.sysUserService.clearCache();
            req.setAttribute("loginname", (Object)user.getLoginname());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.delete"})
    @SLog(tag="\u6279\u91cf\u5220\u9664\u7528\u6237", msg="\u7528\u6237ID:${args[1].getAttribute('ids')}")
    public Object deletes(@Param(value="ids") String[] userIds, HttpServletRequest req) {
        try {
            Sys_user user = (Sys_user)this.sysUserService.fetch((Condition)Cnd.where((String)"loginname", (String)"=", (Object)"superadmin"));
            StringBuilder sb = new StringBuilder();
            for (String s : userIds) {
                if (s.equals(user.getId())) {
                    return Result.error((String)"system.not.allow");
                }
                sb.append(s).append(",");
            }
            this.sysUserService.deleteByIds(userIds);
            this.sysUserService.clearCache();
            req.setAttribute("ids", (Object)sb.toString());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.edit"})
    @SLog(tag="\u542f\u7528\u7528\u6237", msg="\u7528\u6237\u540d:${args[1].getAttribute('loginname')}")
    public Object enable(String userId, HttpServletRequest req) {
        try {
            req.setAttribute("loginname", (Object)((Sys_user)this.sysUserService.fetch(userId)).getLoginname());
            this.sysUserService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)userId));
            this.sysUserService.clear();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.edit"})
    @SLog(tag="\u7981\u7528\u7528\u6237", msg="\u7528\u6237\u540d:${args[1].getAttribute('loginname')}")
    public Object disable(String userId, HttpServletRequest req) {
        try {
            String loginname = ((Sys_user)this.sysUserService.fetch(userId)).getLoginname();
            if ("superadmin".equals(loginname)) {
                return Result.error((String)"system.not.allow");
            }
            req.setAttribute("loginname", (Object)loginname);
            this.sysUserService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)userId));
            this.sysUserService.clear();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/menu/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user"})
    public Object menu(String id, @Param(value="pid") String pid, HttpServletRequest req) {
        try {
            List list = this.sysUserService.getRoleMenus(id, pid);
            ArrayList<NutMap> treeList = new ArrayList<NutMap>();
            for (Sys_menu unit : list) {
                if (!unit.isHasChildren() && this.sysUserService.hasChildren(id, unit.getId())) {
                    unit.setHasChildren(true);
                }
                NutMap map = Lang.obj2nutmap((Object)unit);
                map.addv("expanded", (Object)false);
                map.addv("children", new ArrayList());
                treeList.add(map);
            }
            return Result.success().addData(treeList);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:{locked:'password|salt',ignoreNull:false}")
    @RequiresPermissions(value={"sys.manager.user"})
    public Object data(@Param(value="searchUnit") String searchUnit, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (this.shiroUtil.hasRole("sysadmin")) {
                if (Strings.isNotBlank((CharSequence)searchUnit)) {
                    cnd.and("unitid", "=", (Object)searchUnit);
                }
            } else {
                Sys_user user = (Sys_user)this.shiroUtil.getPrincipal();
                if (Strings.isNotBlank((CharSequence)searchUnit)) {
                    Sys_unit unit = (Sys_unit)this.sysUnitService.fetch(searchUnit);
                    if (unit == null || !searchUnit.startsWith(unit.getPath())) {
                        return Result.error((String)"\u975e\u6cd5\u64cd\u4f5c");
                    }
                    cnd.and("unitid", "=", (Object)searchUnit);
                } else {
                    cnd.and("unitid", "=", (Object)user.getUnitid());
                }
            }
            if (Strings.isNotBlank((CharSequence)searchName) && Strings.isNotBlank((CharSequence)searchKeyword)) {
                cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.sysUserService.listPageLinks(Integer.valueOf(pageNumber), pageSize, (Condition)cnd, "unit"));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="void")
    @RequiresPermissions(value={"sys.manager.user"})
    public void export(@Param(value="searchUnit") String searchUnit, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy, HttpServletResponse response) {
        try {
            J4EConf j4eConf = J4EConf.from(Sys_user.class);
            List jcols = j4eConf.getColumns();
            for (J4EColumn j4eColumn : jcols) {
                if (!"opBy".equals(j4eColumn.getFieldName()) && !"opAt".equals(j4eColumn.getFieldName()) && !"delFlag".equals(j4eColumn.getFieldName())) continue;
                j4eColumn.setIgnore(true);
            }
            Cnd cnd = Cnd.NEW();
            if (this.shiroUtil.hasRole("sysadmin")) {
                if (Strings.isNotBlank((CharSequence)searchUnit)) {
                    cnd.and("unitid", "=", (Object)searchUnit);
                }
            } else {
                Sys_user user = (Sys_user)this.shiroUtil.getPrincipal();
                if (Strings.isNotBlank((CharSequence)searchUnit)) {
                    Sys_unit unit = (Sys_unit)this.sysUnitService.fetch(searchUnit);
                    if (unit == null || !searchUnit.startsWith(unit.getPath())) {
                        throw Lang.makeThrow((String)"\u975e\u6cd5\u64cd\u4f5c", (Object[])new Object[0]);
                    }
                    cnd.and("unitid", "=", (Object)searchUnit);
                } else {
                    cnd.and("unitid", "=", (Object)user.getUnitid());
                }
            }
            if (Strings.isNotBlank((CharSequence)searchName) && Strings.isNotBlank((CharSequence)searchKeyword)) {
                cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            ServletOutputStream out = response.getOutputStream();
            response.addHeader("content-type", "application/shlnd.ms-excel;charset=utf-8");
            response.addHeader("content-disposition", "attachment; filename=sys_user.xls");
            J4E.toExcel((OutputStream)out, (List)this.sysUserService.query((Condition)cnd, "unit"), (J4EConf)j4eConf);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @At
    @Ok(value="beetl:/platform/sys/user/pass.html")
    @RequiresAuthentication
    public void pass() {
    }

    @At
    @Ok(value="beetl:/platform/sys/user/custom.html")
    @RequiresAuthentication
    public void custom() {
    }

    @At
    @Ok(value="beetl:/platform/sys/user/mode.html")
    @RequiresAuthentication
    public void mode() {
    }

    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object modeDo(@Param(value="mode") String mode, HttpServletRequest req) {
        try {
            this.sysUserService.update(Chain.make((String)"loginPjax", (Object)"true".equals(mode)), (Condition)Cnd.where((String)"id", (String)"=", (Object)StringUtil.getPlatformUid()));
            Subject subject = SecurityUtils.getSubject();
            Sys_user user = (Sys_user)subject.getPrincipal();
            if ("true".equals(mode)) {
                user.setLoginPjax(true);
            } else {
                user.setLoginPjax(false);
            }
            this.sysUserService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object customDo(@Param(value="ids") String ids, HttpServletRequest req) {
        try {
            this.sysUserService.update(Chain.make((String)"customMenu", (Object)ids), (Condition)Cnd.where((String)"id", (String)"=", (Object)StringUtil.getPlatformUid()));
            Subject subject = SecurityUtils.getSubject();
            Sys_user user = (Sys_user)subject.getPrincipal();
            if (Strings.isNotBlank((CharSequence)ids)) {
                user.setCustomMenu(ids);
                user.setCustomMenus(this.sysMenuService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)ids.split(","))));
            } else {
                user.setCustomMenu("");
                user.setCustomMenus(new ArrayList());
            }
            this.sysUserService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object doChangePassword(@Param(value="oldPassword") String oldPassword, @Param(value="newPassword") String newPassword, HttpServletRequest req) {
        Subject subject = SecurityUtils.getSubject();
        Sys_user user = (Sys_user)subject.getPrincipal();
        String old = new Sha256Hash((Object)oldPassword, (Object)user.getSalt(), 1024).toHex();
        if (old.equals(user.getPassword())) {
            String salt = R.UU32();
            String hashedPasswordBase64 = new Sha256Hash((Object)newPassword, (Object)ByteSource.Util.bytes((String)salt), 1024).toHex();
            user.setSalt(salt);
            user.setPassword(hashedPasswordBase64);
            this.sysUserService.update(Chain.make((String)"salt", (Object)salt).add("password", (Object)hashedPasswordBase64), (Condition)Cnd.where((String)"id", (String)"=", (Object)user.getId()));
            this.sysUserService.clearCache();
            return Result.success();
        }
        return Result.error();
    }
}

