/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.app.wx.modules.models.Wx_test;
import cn.wizzer.app.wx.modules.services.WxTestService;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.util.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/wx/test"})
public class WxTestController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxTestService wxTestService;

    @At(value={""})
    @Ok(value="beetl:/platform/wx/test/index.html")
    @RequiresPermissions(value={"platform.wx.test"})
    public void index() {
    }

    @At(value={"/data"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"platform.wx.test"})
    public Object data(@Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)searchName) && !Strings.isBlank((CharSequence)searchKeyword)) {
            cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
        }
        if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData((Object)this.wxTestService.listPage(Integer.valueOf(pageNumber), pageSize, (Condition)cnd));
    }

    @At(value={"/addDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"platform.wx.test.add"})
    @SLog(tag="Wx_test", msg="${args[0].id}")
    public Object addDo(@Param(value="..") Wx_test wxTest, HttpServletRequest req) {
        try {
            wxTest.setOpBy(StringUtil.getPlatformUid());
            this.wxTestService.insert((Object)wxTest);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"platform.wx.test"})
    public Object edit(String id, HttpServletRequest req) {
        try {
            return Result.success().addData(this.wxTestService.fetch(id));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/editDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"platform.wx.test.edit"})
    @SLog(tag="Wx_test", msg="${args[0].id}")
    public Object editDo(@Param(value="..") Wx_test wxTest, HttpServletRequest req) {
        try {
            wxTest.setOpBy(StringUtil.getPlatformUid());
            wxTest.setOpAt(Long.valueOf(Times.getTS()));
            this.wxTestService.updateIgnoreNull((Object)wxTest);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?", "/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"platform.wx.test.delete"})
    @SLog(tag="Wx_test", msg="${req.getAttribute('id')}")
    public Object delete(String id, @Param(value="ids") String[] ids, HttpServletRequest req) {
        try {
            if (ids != null && ids.length > 0) {
                this.wxTestService.delete(ids);
                req.setAttribute("id", (Object)StringUtils.toString((Object[])ids));
            } else {
                this.wxTestService.delete(id);
                req.setAttribute("id", (Object)id);
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

