package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.framework.base.Result;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.boot.starter.logback.exts.loglevel.LoglevelCommand;
import org.nutz.boot.starter.logback.exts.loglevel.LoglevelService;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Created by wizzer on 2019/1/18.
 */
@IocBean
@At("/t/sys/redis")
public class SysRedisController {
    private static final Log log = Logs.get();
    @Inject
    private LoglevelService loglevelService;
    @Inject
    private RedisService redisService;

    @At("")
    @Ok("beetl:/platform/sys/monitor/index.html")
    @RequiresPermissions("sys.operation.monitor")
    public void index() {

    }

    @At
    @Ok("json:full")
    @RequiresPermissions("sys.operation.monitor")
    public Object data() {
        try {
            List<NutMap> infoList = new ArrayList<>();
            String[] strs = Objects.requireNonNull(redisService.info()).split("\r\n");
            NutMap redisInfo;
            if (strs.length > 0) {
                for (String str1 : strs) {
                    redisInfo = new NutMap();
                    String[] str = str1.split(":");
                    if (str.length > 1) {
                        String key = str[0];
                        String value = str[1];
                        redisInfo.put(key,value);
                        infoList.add(redisInfo);
                    }
                }
            }
            return Result.success().addData(infoList);
        } catch (Exception e) {
            return Result.error();
        }
    }

}
