/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_dict;
import cn.wizzer.app.sys.modules.services.SysDictService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/dict"})
public class SysDictController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysDictService sysDictService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/dict/index.html")
    @RequiresPermissions(value={"sys.manager.dict"})
    public Object index() {
        return this.sysDictService.query((Condition)Cnd.where((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null).asc("location").asc("path"));
    }

    @At(value={"/child"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object child(@Param(value="pid") String pid, HttpServletRequest req) {
        List list = new ArrayList();
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        Cnd cnd = Cnd.NEW();
        if (Strings.isBlank((CharSequence)pid)) {
            cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
        } else {
            cnd.and("parentId", "=", (Object)pid);
        }
        cnd.asc("location").asc("path");
        list = this.sysDictService.query((Condition)cnd);
        for (Sys_dict sysDict : list) {
            if (this.sysDictService.count((Condition)Cnd.where((String)"parentId", (String)"=", (Object)sysDict.getId())) > 0) {
                sysDict.setHasChildren(true);
            }
            NutMap map = Lang.obj2nutmap((Object)sysDict);
            map.addv("expanded", (Object)false);
            map.addv("children", new ArrayList());
            treeList.add(map);
        }
        return Result.success().addData(treeList);
    }

    @At(value={"/tree"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object tree(@Param(value="pid") String pid, HttpServletRequest req) {
        try {
            ArrayList<NutMap> treeList = new ArrayList<NutMap>();
            if (Strings.isBlank((CharSequence)pid)) {
                NutMap root = NutMap.NEW().addv("value", (Object)"root").addv("label", (Object)"\u4e0d\u9009\u62e9\u83dc\u5355");
                treeList.add(root);
            }
            Cnd cnd = Cnd.NEW();
            if (Strings.isBlank((CharSequence)pid)) {
                cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
            } else {
                cnd.and("parentId", "=", (Object)pid);
            }
            cnd.asc("location").asc("path");
            List list = this.sysDictService.query((Condition)cnd);
            for (Sys_dict sysDict : list) {
                NutMap map = NutMap.NEW().addv("value", (Object)sysDict.getId()).addv("label", (Object)sysDict.getName());
                if (sysDict.isHasChildren()) {
                    map.addv("children", new ArrayList());
                }
                treeList.add(map);
            }
            return Result.success().addData(treeList);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict.add"})
    @SLog(tag="\u65b0\u5efa\u5b57\u5178", msg="\u5b57\u5178\u540d\u79f0:${args[0].name}")
    public Object addDo(@Param(value="..") Sys_dict dict, @Param(value="parentId", df="") String parentId, HttpServletRequest req) {
        try {
            dict.setHasChildren(false);
            dict.setOpBy(StringUtil.getPlatformUid());
            this.sysDictService.save(dict, parentId);
            this.sysDictService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict"})
    public Object edit(String id, HttpServletRequest req) {
        try {
            return Result.success().addData(this.sysDictService.fetch(id));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict.edit"})
    @SLog(tag="\u7f16\u8f91\u5b57\u5178", msg="\u5b57\u5178\u540d\u79f0:${args[0].name}")
    public Object editDo(@Param(value="..") Sys_dict dict, @Param(value="parentId") String parentId, HttpServletRequest req) {
        try {
            dict.setOpBy(StringUtil.getPlatformUid());
            dict.setOpAt(Long.valueOf(Times.getTS()));
            this.sysDictService.updateIgnoreNull((Object)dict);
            this.sysDictService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict.delete"})
    @SLog(tag="\u5220\u9664\u5b57\u5178", msg="\u5b57\u5178\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            Sys_dict dict = (Sys_dict)this.sysDictService.fetch(id);
            req.setAttribute("name", (Object)dict.getName());
            this.sysDictService.deleteAndChild(dict);
            this.sysDictService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict.edit"})
    @SLog(tag="\u542f\u7528\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object enable(String menuId, HttpServletRequest req) {
        try {
            req.setAttribute("name", (Object)((Sys_dict)this.sysDictService.fetch(menuId)).getName());
            this.sysDictService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)menuId));
            this.sysDictService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict.edit"})
    @SLog(tag="\u7981\u7528\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object disable(String menuId, HttpServletRequest req) {
        try {
            req.setAttribute("name", (Object)((Sys_dict)this.sysDictService.fetch(menuId)).getName());
            this.sysDictService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)menuId));
            this.sysDictService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/menuAll"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict"})
    public Object menuAll(HttpServletRequest req) {
        try {
            List list = this.sysDictService.query((Condition)Cnd.NEW().asc("location").asc("path"));
            NutMap menuMap = NutMap.NEW();
            for (Sys_dict unit : list) {
                ArrayList<Sys_dict> list1 = menuMap.getList(unit.getParentId(), Sys_dict.class);
                if (list1 == null) {
                    list1 = new ArrayList<Sys_dict>();
                }
                list1.add(unit);
                menuMap.put((Object)unit.getParentId(), list1);
            }
            return Result.success().addData(this.getTree(menuMap, ""));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    private List<NutMap> getTree(NutMap menuMap, String pid) {
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        List subList = menuMap.getList(pid, Sys_dict.class);
        for (Sys_dict menu : subList) {
            NutMap map = Lang.obj2nutmap((Object)menu);
            map.put((Object)"label", (Object)menu.getName());
            if (menu.isHasChildren() || menuMap.get((Object)menu.getId()) != null) {
                map.put((Object)"children", this.getTree(menuMap, menu.getId()));
            }
            treeList.add(map);
        }
        return treeList;
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict.edit"})
    public Object sortDo(@Param(value="ids") String ids, HttpServletRequest req) {
        try {
            String[] menuIds = StringUtils.split((String)ids, (String)",");
            int i = 0;
            this.sysDictService.execute(Sqls.create((String)"update sys_menu set location=0"));
            for (String s : menuIds) {
                if (Strings.isBlank((CharSequence)s)) continue;
                this.sysDictService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)s));
                ++i;
            }
            this.sysDictService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

