/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.framework.base.Result;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.boot.starter.logback.exts.loglevel.LoglevelService;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;

@IocBean
@At(value={"/t/sys/redis"})
public class SysRedisController {
    private static final Log log = Logs.get();
    @Inject
    private LoglevelService loglevelService;
    @Inject
    private RedisService redisService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/monitor/index.html")
    @RequiresPermissions(value={"sys.operation.monitor"})
    public void index() {
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.operation.monitor"})
    public Object data() {
        try {
            ArrayList<NutMap> infoList = new ArrayList<NutMap>();
            String[] strs = Objects.requireNonNull(this.redisService.info()).split("\r\n");
            if (strs.length > 0) {
                for (String str1 : strs) {
                    NutMap redisInfo = new NutMap();
                    String[] str = str1.split(":");
                    if (str.length <= 1) continue;
                    String key = str[0];
                    String value = str[1];
                    redisInfo.put((Object)key, (Object)value);
                    infoList.add(redisInfo);
                }
            }
            return Result.success().addData(infoList);
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

