/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_app_conf;
import cn.wizzer.app.sys.modules.models.Sys_app_list;
import cn.wizzer.app.sys.modules.models.Sys_app_task;
import cn.wizzer.app.sys.modules.services.SysAppConfService;
import cn.wizzer.app.sys.modules.services.SysAppListService;
import cn.wizzer.app.sys.modules.services.SysAppTaskService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.boot.starter.ftp.FtpService;
import org.nutz.boot.starter.logback.exts.loglevel.LoglevelCommand;
import org.nutz.boot.starter.logback.exts.loglevel.LoglevelProperty;
import org.nutz.boot.starter.logback.exts.loglevel.LoglevelService;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.stream.StringInputStream;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/app"})
public class SysAppController {
    private static final Log log = Logs.get();
    @Inject
    private LoglevelService loglevelService;
    @Inject
    @Reference
    private SysAppListService sysAppListService;
    @Inject
    @Reference
    private SysAppConfService sysAppConfService;
    @Inject
    @Reference
    private SysAppTaskService sysAppTaskService;
    @Inject
    private FtpService ftpService;
    @Inject
    private RedisService redisService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/app/index.html")
    @RequiresPermissions(value={"sys.operation.app"})
    public void index() {
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.operation.app"})
    public Object data(@Param(value="hostName") String hostName) {
        try {
            ArrayList<NutMap> hostList = new ArrayList<NutMap>();
            NutMap map = this.loglevelService.getData();
            ArrayList<LoglevelProperty> dataList = new ArrayList<LoglevelProperty>();
            for (Map.Entry entry : map.entrySet()) {
                List list = (List)entry.getValue();
                for (LoglevelProperty property : list) {
                    NutMap nutMap = NutMap.NEW().addv("hostName", (Object)property.getHostName()).addv("hostAddress", (Object)property.getHostAddress());
                    if (!hostList.contains(nutMap)) {
                        hostList.add(nutMap);
                    }
                    if (!Strings.isBlank((CharSequence)hostName) && (!Strings.isNotBlank((CharSequence)hostName) || !property.getHostName().equals(hostName))) continue;
                    dataList.add(property);
                }
            }
            return Result.success().addData((Object)NutMap.NEW().addv("hostList", hostList).addv("appList", dataList));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.operation.app"})
    public Object osData(@Param(value="hostName") String hostName) {
        try {
            ArrayList hostList = new ArrayList();
            Set set = this.redisService.keys("logback:deploy:" + hostName + ":*");
            ArrayList list = new ArrayList(set);
            Collections.sort(list);
            ArrayList<Object> dataList = new ArrayList<Object>();
            for (String key : list) {
                dataList.add(Json.fromJson(NutMap.class, (CharSequence)this.redisService.get(key)));
            }
            return Result.success().addData(dataList);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/version"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app"})
    public Object version(@Param(value="name") String name) {
        try {
            List appVerList = this.sysAppListService.query((Condition)Cnd.where((String)"disabled", (String)"=", (Object)false).and("appName", "=", (Object)name).desc("opAt"), new Pager().setPageNumber(1).setPageSize(10));
            List confVerList = this.sysAppConfService.query((Condition)Cnd.where((String)"disabled", (String)"=", (Object)false).and("confName", "=", (Object)name).desc("opAt"), new Pager().setPageNumber(1).setPageSize(10));
            return Result.success().addData((Object)NutMap.NEW().addv("appVerList", (Object)appVerList).addv("confVerList", (Object)confVerList));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/jar"})
    @Ok(value="beetl:/platform/sys/app/jar.html")
    @RequiresPermissions(value={"sys.operation.app"})
    public void jar() {
    }

    @At(value={"/jar/data"})
    @Ok(value="json:{locked:'password|salt',ignoreNull:false}")
    @RequiresPermissions(value={"sys.operation.app.jar"})
    public Object jarData(@Param(value="appName") String appName, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (Strings.isNotBlank((CharSequence)appName)) {
                cnd.and("appName", "like", (Object)("%" + appName + "%"));
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.sysAppListService.listPageLinks(Integer.valueOf(pageNumber), pageSize, (Condition)cnd, "^(user)$"));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/jar/addDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.jar"})
    @SLog(tag="\u6dfb\u52a0\u5b89\u88c5\u5305", msg="\u5e94\u7528\u540d\u79f0:${sysAppList.appName}")
    public Object jarAddDo(@Param(value="..") Sys_app_list sysAppList, HttpServletRequest req) {
        try {
            int num = this.sysAppListService.count((Condition)Cnd.where((String)"appName", (String)"=", (Object)Strings.trim((CharSequence)sysAppList.getAppName())).and("appVersion", "=", (Object)Strings.trim((CharSequence)sysAppList.getAppVersion())));
            if (num > 0) {
                return Result.error((String)"\u7248\u672c\u53f7\u5df2\u5b58\u5728");
            }
            sysAppList.setAppName(Strings.trim((CharSequence)sysAppList.getAppName()));
            sysAppList.setAppVersion(Strings.trim((CharSequence)sysAppList.getAppVersion()));
            sysAppList.setOpBy(StringUtil.getPlatformUid());
            this.sysAppListService.insert((Object)sysAppList);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/jar/search"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.jar"})
    public Object jarSearch(@Param(value="appName") String appName) {
        return Result.NEW().addData((Object)this.sysAppListService.getAppNameList());
    }

    @At(value={"/jar/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.jar"})
    @SLog(tag="\u5220\u9664Jar\u5305", msg="ID:${id}")
    public Object jarDelete(String id, HttpServletRequest req) {
        try {
            this.sysAppListService.delete(id);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/jar/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.jar"})
    @SLog(tag="\u542f\u7528Jar\u5305", msg="ID:${id}")
    public Object jarEnable(String id, HttpServletRequest req) {
        try {
            this.sysAppListService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/jar/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.jar"})
    @SLog(tag="\u7981\u7528Jar\u5305", msg="ID:${id}")
    public Object jarDisable(String id, HttpServletRequest req) {
        try {
            this.sysAppListService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/jar/download/?"})
    @Ok(value="void")
    @RequiresPermissions(value={"sys.operation.app.jar"})
    public void jarDownload(String id, HttpServletResponse response) {
        try {
            Sys_app_list sysAppList = (Sys_app_list)this.sysAppListService.fetch(id);
            String fileName1 = sysAppList.getAppName() + "-" + sysAppList.getAppVersion() + ".jar";
            response.setHeader("Content-Type", "application/java-archive");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName1);
            response.setContentLengthLong(sysAppList.getFileSize().longValue());
            this.ftpService.download(sysAppList.getFilePath(), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @At(value={"/conf"})
    @Ok(value="beetl:/platform/sys/app/conf.html")
    @RequiresPermissions(value={"sys.operation.app"})
    public void conf() {
    }

    @At(value={"/conf/data"})
    @Ok(value="json:{locked:'confData|password|salt',ignoreNull:false}")
    @RequiresPermissions(value={"sys.operation.app.conf"})
    public Object confData(@Param(value="confName") String confName, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (Strings.isNotBlank((CharSequence)confName)) {
                cnd.and("confName", "like", (Object)("%" + confName + "%"));
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.sysAppConfService.listPageLinks(Integer.valueOf(pageNumber), pageSize, (Condition)cnd, "^(user)$"));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/conf/addDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.conf"})
    @SLog(tag="\u6dfb\u52a0\u914d\u7f6e\u6587\u4ef6", msg="\u5e94\u7528\u540d\u79f0:${sysAppConf.confName}")
    public Object confAddDo(@Param(value="..") Sys_app_conf sysAppConf, HttpServletRequest req) {
        try {
            int num = this.sysAppConfService.count((Condition)Cnd.where((String)"confName", (String)"=", (Object)Strings.trim((CharSequence)sysAppConf.getConfName())).and("confVersion", "=", (Object)Strings.trim((CharSequence)sysAppConf.getConfVersion())));
            if (num > 0) {
                return Result.error((String)"\u7248\u672c\u53f7\u5df2\u5b58\u5728");
            }
            sysAppConf.setConfName(Strings.trim((CharSequence)sysAppConf.getConfName()));
            sysAppConf.setConfVersion(Strings.trim((CharSequence)sysAppConf.getConfVersion()));
            sysAppConf.setOpBy(StringUtil.getPlatformUid());
            this.sysAppConfService.insert((Object)sysAppConf);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/conf/search"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.conf"})
    public Object confSearch(@Param(value="confName") String confName) {
        return Result.NEW().addData((Object)this.sysAppConfService.getConfNameList());
    }

    @At(value={"/conf/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.conf"})
    @SLog(tag="\u5220\u9664\u914d\u7f6e\u6587\u4ef6", msg="ID:${id}")
    public Object confDelete(String id, HttpServletRequest req) {
        try {
            this.sysAppConfService.delete(id);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/conf/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.conf"})
    @SLog(tag="\u542f\u7528\u914d\u7f6e\u6587\u4ef6", msg="ID:${id}")
    public Object confEnable(String id, HttpServletRequest req) {
        try {
            this.sysAppConfService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/conf/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.conf"})
    @SLog(tag="\u7981\u7528\u914d\u7f6e\u6587\u4ef6", msg="ID:${id}")
    public Object confDisable(String id, HttpServletRequest req) {
        try {
            this.sysAppConfService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/conf/download/?"})
    @Ok(value="void")
    @RequiresPermissions(value={"sys.operation.app.conf"})
    public void confDownload(String id, HttpServletResponse response) {
        try {
            Sys_app_conf conf = (Sys_app_conf)this.sysAppConfService.fetch(id);
            String fileName = conf.getConfName() + "-" + conf.getConfVersion() + ".properties";
            response.setHeader("Content-Type", "text/plain");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            try (StringInputStream in = new StringInputStream((CharSequence)conf.getConfData());){
                Streams.writeAndClose((OutputStream)response.getOutputStream(), (InputStream)in);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @At(value={"/conf/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.conf"})
    public Object confEdit(@Param(value="id") String id) {
        return Result.NEW().addData(this.sysAppConfService.fetch(id));
    }

    @At(value={"/conf/editDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.conf"})
    @SLog(tag="\u4fee\u6539\u914d\u7f6e\u6587\u4ef6", msg="\u5e94\u7528\u540d\u79f0:${sysAppConf.confName}")
    public Object confEditDo(@Param(value="..") Sys_app_conf sysAppConf, HttpServletRequest req) {
        try {
            sysAppConf.setOpBy(StringUtil.getPlatformUid());
            this.sysAppConfService.updateIgnoreNull((Object)sysAppConf);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/task/addDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.instance"})
    @SLog(tag="\u521b\u5efa\u4efb\u52a1", msg="\u5e94\u7528\u540d\u79f0:${appTask.getName()} \u52a8\u4f5c:${appTask.getAction()}")
    public Object taskAddDo(@Param(value="..") Sys_app_task appTask, HttpServletRequest req) {
        try {
            int num;
            Cnd cnd = Cnd.where((String)"name", (String)"=", (Object)appTask.getName()).and("action", "=", (Object)"stop").and("appVersion", "=", (Object)appTask.getAppVersion()).and("confVersion", "=", (Object)appTask.getConfVersion()).and("hostName", "=", (Object)appTask.getHostName()).and("hostAddress", "=", (Object)appTask.getHostAddress()).and((SqlExpression)Cnd.exps((String)"status", (String)"=", (Object)0).or("status", "=", (Object)1));
            if ("stop".equals(appTask.getAction())) {
                cnd.and("processId", "=", (Object)appTask.getProcessId());
            }
            if ((num = this.sysAppTaskService.count((Condition)cnd)) > 0) {
                return Result.error((String)"\u4efb\u52a1\u5df2\u5b58\u5728\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u6267\u884c\u7ed3\u679c");
            }
            appTask.setOpBy(StringUtil.getPlatformUid());
            appTask.setStatus(Integer.valueOf(0));
            this.sysAppTaskService.insert((Object)appTask);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/task/data"})
    @Ok(value="json:{locked:'confData',ignoreNull:false}")
    @RequiresPermissions(value={"sys.operation.app"})
    public Object taskData(@Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.sysAppTaskService.listPageLinks(Integer.valueOf(pageNumber), pageSize, (Condition)cnd, "^(user)$"));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/task/cannel/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.instance"})
    @SLog(tag="\u53d6\u6d88\u4efb\u52a1", msg="\u4efb\u52a1ID:${id}")
    public Object taskAddDo(String id, HttpServletRequest req) {
        try {
            this.sysAppTaskService.update(Chain.make((String)"status", (Object)4), (Condition)Cnd.where((String)"id", (String)"=", (Object)id).and("status", "=", (Object)0));
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.operation.app.loglevel"})
    public Object loglevel(@Param(value="action") String action, @Param(value="name") String name, @Param(value="processId") String processId, @Param(value="loglevel") String loglevel) {
        try {
            LoglevelCommand loglevelCommand = new LoglevelCommand();
            loglevelCommand.setAction(action);
            loglevelCommand.setLevel(loglevel);
            if ("processId".equals(action)) {
                loglevelCommand.setProcessId(processId);
            }
            loglevelCommand.setName(name);
            this.loglevelService.changeLoglevel(loglevelCommand);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

