/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_unit;
import cn.wizzer.app.sys.modules.models.Sys_user;
import cn.wizzer.app.sys.modules.services.SysUnitService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.ShiroUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/unit"})
public class SysUnitController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysUnitService sysUnitService;
    @Inject
    private ShiroUtil shiroUtil;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/unit/index.html")
    @RequiresPermissions(value={"sys.manager.unit"})
    public void index() {
    }

    @At(value={"/child"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object child(@Param(value="pid") String pid, HttpServletRequest req) {
        List list = new ArrayList();
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        if (this.shiroUtil.hasRole("sysadmin")) {
            Cnd cnd = Cnd.NEW();
            if (Strings.isBlank((CharSequence)pid)) {
                cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
            } else {
                cnd.and("parentId", "=", (Object)pid);
            }
            cnd.asc("location").asc("path");
            list = this.sysUnitService.query((Condition)cnd);
        } else {
            Sys_user user = (Sys_user)this.shiroUtil.getPrincipal();
            if (user != null && Strings.isBlank((CharSequence)pid)) {
                list = this.sysUnitService.query((Condition)Cnd.where((String)"id", (String)"=", (Object)user.getUnitid()).asc("path"));
            } else {
                Cnd cnd = Cnd.NEW();
                if (Strings.isBlank((CharSequence)pid)) {
                    cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
                } else {
                    cnd.and("parentId", "=", (Object)pid);
                }
                cnd.asc("location").asc("path");
                list = this.sysUnitService.query((Condition)cnd);
            }
        }
        for (Sys_unit unit : list) {
            NutMap map = Lang.obj2nutmap((Object)unit);
            map.addv("expanded", (Object)false);
            map.addv("children", new ArrayList());
            treeList.add(map);
        }
        return Result.success().addData(treeList);
    }

    @At(value={"/tree"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object tree(@Param(value="pid") String pid, HttpServletRequest req) {
        try {
            List list = new ArrayList();
            ArrayList<NutMap> treeList = new ArrayList<NutMap>();
            if (Strings.isBlank((CharSequence)pid)) {
                NutMap root = NutMap.NEW().addv("value", (Object)"root").addv("label", (Object)"\u4e0d\u9009\u62e9\u5355\u4f4d");
                treeList.add(root);
            }
            if (this.shiroUtil.hasRole("sysadmin")) {
                Cnd cnd = Cnd.NEW();
                if (Strings.isBlank((CharSequence)pid)) {
                    cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
                } else {
                    cnd.and("parentId", "=", (Object)pid);
                }
                cnd.asc("location").asc("path");
                list = this.sysUnitService.query((Condition)cnd);
            } else {
                Sys_user user = (Sys_user)this.shiroUtil.getPrincipal();
                if (user != null && Strings.isBlank((CharSequence)pid)) {
                    list = this.sysUnitService.query((Condition)Cnd.where((String)"id", (String)"=", (Object)user.getUnitid()).asc("path"));
                } else {
                    Cnd cnd = Cnd.NEW();
                    if (Strings.isBlank((CharSequence)pid)) {
                        cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
                    } else {
                        cnd.and("parentId", "=", (Object)pid);
                    }
                    cnd.asc("location").asc("path");
                    list = this.sysUnitService.query((Condition)cnd);
                }
            }
            for (Sys_unit unit : list) {
                NutMap map = NutMap.NEW().addv("value", (Object)unit.getId()).addv("label", (Object)unit.getName());
                if (unit.isHasChildren()) {
                    map.addv("children", new ArrayList());
                }
                treeList.add(map);
            }
            return Result.success().addData(treeList);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.unit.add"})
    @SLog(tag="\u65b0\u5efa\u5355\u4f4d", msg="\u5355\u4f4d\u540d\u79f0:${args[0].name}")
    public Object addDo(@Param(value="..") Sys_unit unit, @Param(value="parentId") String parentId, HttpServletRequest req) {
        try {
            unit.setOpBy(StringUtil.getPlatformUid());
            this.sysUnitService.save(unit, parentId);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.unit"})
    public Object edit(String id, HttpServletRequest req) {
        try {
            Sys_unit unit = (Sys_unit)this.sysUnitService.fetch(id);
            return Result.success().addData((Object)unit);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.unit.edit"})
    @SLog(tag="\u7f16\u8f91\u5355\u4f4d", msg="\u5355\u4f4d\u540d\u79f0:${args[0].name}")
    public Object editDo(@Param(value="..") Sys_unit unit, @Param(value="parentId") String parentId, HttpServletRequest req) {
        try {
            unit.setOpBy(StringUtil.getPlatformUid());
            unit.setOpAt(Long.valueOf(Times.getTS()));
            this.sysUnitService.updateIgnoreNull((Object)unit);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.unit.delete"})
    @SLog(tag="\u5220\u9664\u5355\u4f4d", msg="\u5355\u4f4d\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            Sys_unit unit = (Sys_unit)this.sysUnitService.fetch(id);
            req.setAttribute("name", (Object)unit.getName());
            if ("0001".equals(unit.getPath())) {
                return Result.error((String)"system.not.allow");
            }
            this.sysUnitService.deleteAndChild(unit);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

