/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.cms;

import cn.wizzer.app.cms.modules.models.Cms_channel;
import cn.wizzer.app.cms.modules.models.Cms_site;
import cn.wizzer.app.cms.modules.services.CmsChannelService;
import cn.wizzer.app.cms.modules.services.CmsSiteService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/cms/channel"})
public class CmsChannelController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private CmsChannelService cmsChannelService;
    @Inject
    @Reference
    private CmsSiteService cmsSiteService;

    @At(value={"", "/?"})
    @Ok(value="beetl:/platform/cms/channel/index.html")
    @RequiresPermissions(value={"cms.content.channel"})
    public void index(String siteId, HttpServletRequest req) {
        Cms_site site = null;
        List siteList = this.cmsSiteService.query();
        if (Strings.isBlank((CharSequence)siteId) && siteList.size() > 0) {
            site = (Cms_site)siteList.get(0);
        }
        if (Strings.isNotBlank((CharSequence)siteId)) {
            site = (Cms_site)this.cmsSiteService.fetch(siteId);
        }
        req.setAttribute("siteList", (Object)siteList);
        req.setAttribute("site", (Object)site);
    }

    @At(value={"/child/?"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object child(String siteId, @Param(value="pid") String pid, HttpServletRequest req) {
        List list = new ArrayList();
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        Cnd cnd = Cnd.NEW();
        if (Strings.isBlank((CharSequence)pid)) {
            cnd.and((SqlExpression)Cnd.exps((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null));
        } else {
            cnd.and("parentId", "=", (Object)pid);
        }
        cnd.and("siteid", "=", (Object)siteId);
        cnd.asc("location").asc("path");
        list = this.cmsChannelService.query((Condition)cnd);
        for (Cms_channel channel : list) {
            if (this.cmsChannelService.count((Condition)Cnd.where((String)"parentId", (String)"=", (Object)channel.getId())) > 0) {
                channel.setHasChildren(true);
            }
            NutMap map = Lang.obj2nutmap((Object)channel);
            map.addv("expanded", (Object)false);
            map.addv("children", new ArrayList());
            treeList.add(map);
        }
        return Result.success().addData(treeList);
    }

    @At(value={"/tree/?"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object tree(String siteId, @Param(value="pid") String pid, HttpServletRequest req) {
        try {
            ArrayList<NutMap> treeList = new ArrayList<NutMap>();
            if (Strings.isBlank((CharSequence)pid)) {
                NutMap root = NutMap.NEW().addv("value", (Object)"root").addv("label", (Object)"\u4e0d\u9009\u62e9\u83dc\u5355");
                treeList.add(root);
            }
            Cnd cnd = Cnd.NEW();
            if (Strings.isBlank((CharSequence)pid)) {
                cnd.and((SqlExpression)Cnd.exps((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null));
            } else {
                cnd.and("parentId", "=", (Object)pid);
            }
            cnd.and("siteid", "=", (Object)siteId);
            cnd.asc("location").asc("path");
            List list = this.cmsChannelService.query((Condition)cnd);
            for (Cms_channel menu : list) {
                NutMap map = NutMap.NEW().addv("value", (Object)menu.getId()).addv("label", (Object)menu.getName());
                if (menu.isHasChildren()) {
                    map.addv("children", new ArrayList());
                }
                treeList.add(map);
            }
            return Result.success().addData(treeList);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.add"})
    @SLog(tag="\u65b0\u5efa\u680f\u76ee", msg="\u680f\u76ee\u540d\u79f0:${args[0].name}")
    public Object addDo(@Param(value="..") Cms_channel channel, @Param(value="parentId", df="") String parentId, HttpServletRequest req) {
        try {
            channel.setOpBy(StringUtil.getPlatformUid());
            this.cmsChannelService.save(channel, parentId);
            this.cmsChannelService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel"})
    public Object edit(String id, HttpServletRequest req) {
        try {
            Cms_channel channel = (Cms_channel)this.cmsChannelService.fetch(id);
            NutMap map = Lang.obj2nutmap((Object)channel);
            map.put((Object)"parentName", (Object)"\u65e0");
            map.put((Object)"siteName", (Object)"\u65e0");
            if (Strings.isNotBlank((CharSequence)channel.getParentId())) {
                map.put((Object)"parentName", (Object)((Cms_channel)this.cmsChannelService.fetch(channel.getParentId())).getName());
            }
            if (Strings.isNotBlank((CharSequence)channel.getSiteid())) {
                map.put((Object)"siteName", (Object)((Cms_site)this.cmsSiteService.fetch(channel.getSiteid())).getSite_name());
            }
            return Result.success().addData((Object)map);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.edit"})
    @SLog(tag="\u7f16\u8f91\u680f\u76ee", msg="\u680f\u76ee\u540d\u79f0:${args[0].name}")
    public Object editDo(@Param(value="..") Cms_channel channel, HttpServletRequest req) {
        try {
            channel.setOpBy(StringUtil.getPlatformUid());
            channel.setOpAt(Long.valueOf(Times.getTS()));
            this.cmsChannelService.updateIgnoreNull((Object)channel);
            this.cmsChannelService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.delete"})
    @SLog(tag="\u5220\u9664\u680f\u76ee", msg="\u680f\u76ee\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            Cms_channel channel = (Cms_channel)this.cmsChannelService.fetch(id);
            req.setAttribute("name", (Object)channel.getName());
            this.cmsChannelService.deleteAndChild(channel);
            this.cmsChannelService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.edit"})
    @SLog(tag="\u542f\u7528\u680f\u76ee", msg="\u680f\u76ee\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object enable(String menuId, HttpServletRequest req) {
        try {
            req.setAttribute("name", (Object)((Cms_channel)this.cmsChannelService.fetch(menuId)).getName());
            this.cmsChannelService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)menuId));
            this.cmsChannelService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.edit"})
    @SLog(tag="\u7981\u7528\u680f\u76ee", msg="\u680f\u76ee\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object disable(String menuId, HttpServletRequest req) {
        try {
            req.setAttribute("name", (Object)((Cms_channel)this.cmsChannelService.fetch(menuId)).getName());
            this.cmsChannelService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)menuId));
            this.cmsChannelService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/sort/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel"})
    public Object sort(String siteid, HttpServletRequest req) {
        try {
            List list = this.cmsChannelService.query((Condition)Cnd.where((String)"siteid", (String)"=", (Object)siteid).asc("location").asc("path"));
            NutMap menuMap = NutMap.NEW();
            for (Cms_channel unit : list) {
                ArrayList<Cms_channel> list1 = menuMap.getList(unit.getParentId(), Cms_channel.class);
                if (list1 == null) {
                    list1 = new ArrayList<Cms_channel>();
                }
                list1.add(unit);
                menuMap.put((Object)unit.getParentId(), list1);
            }
            return Result.success().addData(this.getTree(menuMap, ""));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    private List<NutMap> getTree(NutMap menuMap, String pid) {
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        List subList = menuMap.getList(pid, Cms_channel.class);
        for (Cms_channel menu : subList) {
            NutMap map = Lang.obj2nutmap((Object)menu);
            map.put((Object)"label", (Object)menu.getName());
            if (menu.isHasChildren() || menuMap.get((Object)menu.getId()) != null) {
                map.put((Object)"children", this.getTree(menuMap, menu.getId()));
            }
            treeList.add(map);
        }
        return treeList;
    }

    @At(value={"/sortDo/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.sort"})
    public Object sortDo(String siteid, @Param(value="ids") String ids, HttpServletRequest req) {
        try {
            String[] menuIds = StringUtils.split((String)ids, (String)",");
            int i = 0;
            this.cmsChannelService.execute(Sqls.create((String)"update cms_channel set location=0 where siteid=@siteid").setParam("siteid", (Object)siteid));
            for (String s : menuIds) {
                if (Strings.isBlank((CharSequence)s)) continue;
                this.cmsChannelService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)s));
                ++i;
            }
            this.cmsChannelService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

