/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.front.wx;

import cn.wizzer.app.web.commons.base.Globals;
import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_user;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxUserService;
import com.alibaba.dubbo.config.annotation.Reference;
import com.vdurmont.emoji.EmojiParser;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.http.Http;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Filters;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/public/wx/wechat"})
public class WechatController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxConfigService wxConfigService;
    @Inject
    @Reference
    private WxUserService wxUserService;
    @Inject
    private WxService wxService;

    @At(value={"/?/oauth"})
    @Ok(value="re")
    @Filters
    public String oauth(String wxid, @Param(value="goto_url", df="/public/wx/cms/channel") String goto_url, HttpServletRequest req, HttpSession session) throws Exception {
        session.setAttribute("wechat_goto_url", (Object)goto_url);
        if (!Strings.isBlank((CharSequence)wxid)) {
            Wx_config config = (Wx_config)this.wxConfigService.fetch(wxid);
            String back_url = Globals.AppDomain + "/public/wx/wechat/" + wxid + "/back";
            String redirect_uri = URLEncoder.encode(back_url, "utf-8");
            log.debug((Object)("redirect_uri::" + redirect_uri));
            String state = "wechat";
            String scope = "snsapi_base";
            String oauth_url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + config.getAppid() + "&redirect_uri=" + redirect_uri + "&response_type=code&scope=" + scope + "&state=" + state + "#wechat_redirect";
            return "redirect:" + oauth_url;
        }
        return "redirect:" + goto_url;
    }

    @At(value={"/?/back"})
    @Ok(value="re")
    @Filters
    public String back(String wxid, @Param(value="code") String code, HttpServletRequest req, HttpSession session) throws Exception {
        String wechat_goto_url = Strings.sNull((Object)session.getAttribute("wechat_goto_url"));
        Wx_config config = (Wx_config)this.wxConfigService.fetch(wxid);
        String fmt = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
        String url = String.format(fmt, config.getAppid(), config.getAppsecret(), code);
        String json = Http.get((String)url).getContent();
        NutMap map = (NutMap)Json.fromJson(NutMap.class, (CharSequence)json);
        String openid = map.getString("openid");
        WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
        Wx_user usr = (Wx_user)this.wxUserService.fetch((Condition)Cnd.where((String)"openid", (String)"=", (Object)openid).and("wxid", "=", (Object)wxid));
        WxResp resp = wxApi2.user_info(openid, "zh_CN");
        if (usr == null) {
            usr = (Wx_user)Json.fromJson(Wx_user.class, (CharSequence)Json.toJson((Object)resp.user()));
            if (usr != null && usr.getNickname() != null) {
                usr.setNickname(Strings.sNull((Object)EmojiParser.parseToAliases((String)usr.getNickname(), (EmojiParser.FitzpatrickAction)EmojiParser.FitzpatrickAction.REMOVE)));
                usr.setSubscribeAt(Long.valueOf(resp.user().getSubscribe_time()));
                usr.setWxid(wxid);
                this.wxUserService.insert((Object)usr);
            }
        } else {
            String id = usr.getId();
            usr = (Wx_user)Json.fromJson(Wx_user.class, (CharSequence)Json.toJson((Object)resp.user()));
            usr.setNickname(EmojiParser.parseToAliases((String)usr.getNickname(), (EmojiParser.FitzpatrickAction)EmojiParser.FitzpatrickAction.REMOVE));
            usr.setOpAt(Long.valueOf(Times.getTS()));
            usr.setWxid(wxid);
            usr.setId(id);
            this.wxUserService.updateIgnoreNull((Object)usr);
        }
        session.setAttribute("wxid", (Object)wxid);
        session.setAttribute("openid", (Object)(usr == null ? "" : usr.getOpenid()));
        return "redirect:" + wechat_goto_url;
    }
}

