/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.open.ueditor;

import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import com.alibaba.dubbo.config.annotation.Reference;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.impl.AdaptorErrorContext;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadAdaptor;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/open/ueditor/wx"})
public class WxController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxConfigService wxConfigService;
    @Inject
    private WxService wxService;

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:imageUpload"})
    @POST
    @At
    @Ok(value="raw")
    @RequiresAuthentication
    public Object uploadimage(@Param(value="Filedata") TempFile tf, @Param(value="callback") String callback, HttpServletRequest req, AdaptorErrorContext err) {
        String wxid = Strings.sBlank((Object)req.getSession().getAttribute("wxid"));
        NutMap nutMap = new NutMap();
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return Json.toJson((Object)nutMap.addv("state", (Object)"FAIL"));
            }
            if (tf == null) {
                return Json.toJson((Object)nutMap.addv("state", (Object)"FAIL"));
            }
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            WxResp resp = wxApi2.uploadimg(tf.getFile());
            if (resp.errcode() != 0) {
                return Json.toJson((Object)nutMap.addv("state", (Object)"FAIL"));
            }
            nutMap.addv("name", (Object)tf.getName());
            nutMap.addv("state", (Object)"SUCCESS");
            nutMap.addv("url", (Object)Strings.sNull((Object)resp.get((Object)"url")).replace("http://", "https://"));
            nutMap.addv("originalName", (Object)tf.getSubmittedFileName());
            nutMap.addv("type", (Object)tf.getSubmittedFileName().substring(tf.getSubmittedFileName().lastIndexOf(".") + 1));
            nutMap.addv("size", (Object)tf.getSize());
            if (Strings.isBlank((CharSequence)callback)) {
                return Json.toJson((Object)nutMap);
            }
            return "<script>" + callback + "(" + Json.toJson((Object)nutMap) + ")</script>";
        }
        catch (Exception e) {
            e.printStackTrace();
            return Json.toJson((Object)nutMap.addv("state", (Object)"FAIL"));
        }
    }
}

