/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.processor;

import cn.wizzer.framework.base.Result;
import java.lang.reflect.Method;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.aop.MethodInvocation;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.nutz.integration.shiro.NutShiro;
import org.nutz.integration.shiro.NutShiroInterceptor;
import org.nutz.integration.shiro.NutShiroMethodInterceptor;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.View;
import org.nutz.mvc.impl.processor.AbstractProcessor;
import org.nutz.mvc.view.ServerRedirectView;

public class NutShiroProcessor
extends AbstractProcessor {
    protected NutShiroMethodInterceptor interceptor = new NutShiroMethodInterceptor();
    protected String loginUri = "/platform/login";
    protected String noAuthUri = "/platform/login/noPermission";
    protected boolean match;
    protected boolean init;

    public void init(NutConfig config, ActionInfo ai) throws Throwable {
        if (this.init) {
            throw new IllegalStateException("this Processor have bean inited!!");
        }
        super.init(config, ai);
        this.match = NutShiro.match((Method)ai.getMethod());
        this.init = true;
    }

    public void process(ActionContext ac) throws Throwable {
        if (this.match) {
            try {
                this.interceptor.assertAuthorized((MethodInvocation)new NutShiroInterceptor(ac));
            }
            catch (Exception e) {
                this.whenException(ac, e);
                return;
            }
        }
        this.doNext(ac);
    }

    protected void whenException(ActionContext ac, Exception e) throws Throwable {
        Object val = ac.getRequest().getAttribute("shiro_auth_error");
        if (val != null && val instanceof View) {
            ((View)val).render(ac.getRequest(), ac.getResponse(), null);
            return;
        }
        if (e instanceof UnauthenticatedException) {
            this.whenUnauthenticated(ac, (UnauthenticatedException)e);
        } else if (e instanceof UnauthorizedException) {
            this.whenUnauthorized(ac, (UnauthorizedException)e);
        } else {
            this.whenOtherException(ac, e);
        }
    }

    protected void whenUnauthenticated(ActionContext ac, UnauthenticatedException e) throws Exception {
        if (NutShiro.isAjax((ServletRequest)ac.getRequest())) {
            ac.getResponse().addHeader("loginStatus", "accessDenied");
            NutShiro.rendAjaxResp((ServletRequest)ac.getRequest(), (ServletResponse)ac.getResponse(), (Object)Result.error((String)"\u767b\u5f55\u5931\u6548"));
        } else {
            new ServerRedirectView(this.loginUri).render(ac.getRequest(), ac.getResponse(), null);
        }
    }

    protected void whenUnauthorized(ActionContext ac, UnauthorizedException e) throws Exception {
        if (NutShiro.isAjax((ServletRequest)ac.getRequest())) {
            ac.getResponse().addHeader("loginStatus", "unauthorized");
            NutShiro.rendAjaxResp((ServletRequest)ac.getRequest(), (ServletResponse)ac.getResponse(), (Object)Result.error((String)"\u6ca1\u6709\u6743\u9650"));
        } else {
            new ServerRedirectView(this.noAuthUri).render(ac.getRequest(), ac.getResponse(), null);
        }
    }

    protected void whenOtherException(ActionContext ac, Exception e) throws Exception {
        if (NutShiro.isAjax((ServletRequest)ac.getRequest())) {
            ac.getResponse().addHeader("loginStatus", "accessDenied");
            NutShiro.rendAjaxResp((ServletRequest)ac.getRequest(), (ServletResponse)ac.getResponse(), (Object)Result.error((String)"\u767b\u5f55\u5931\u6548"));
        } else {
            new ServerRedirectView(this.loginUri).render(ac.getRequest(), ac.getResponse(), null);
        }
    }
}

