/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.cms;

import cn.wizzer.app.cms.modules.models.Cms_article;
import cn.wizzer.app.cms.modules.models.Cms_channel;
import cn.wizzer.app.cms.modules.models.Cms_site;
import cn.wizzer.app.cms.modules.services.CmsArticleService;
import cn.wizzer.app.cms.modules.services.CmsChannelService;
import cn.wizzer.app.cms.modules.services.CmsSiteService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.util.StringUtils;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.adaptor.WhaleAdaptor;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/cms/article"})
public class CmsArticleController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private CmsArticleService cmsArticleService;
    @Inject
    @Reference
    private CmsChannelService cmsChannelService;
    @Inject
    @Reference
    private CmsSiteService cmsSiteService;

    @At(value={"", "/?"})
    @Ok(value="beetl:/platform/cms/article/index.html")
    @RequiresPermissions(value={"cms.content.article"})
    public void index(String siteId, HttpServletRequest req) {
        Cms_site site = null;
        List siteList = this.cmsSiteService.query();
        if (Strings.isBlank((CharSequence)siteId) && siteList.size() > 0) {
            site = (Cms_site)siteList.get(0);
        }
        if (Strings.isNotBlank((CharSequence)siteId)) {
            site = (Cms_site)this.cmsSiteService.fetch(siteId);
        }
        req.setAttribute("siteList", (Object)siteList);
        req.setAttribute("site", (Object)site);
    }

    @At(value={"/tree/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article"})
    public Object tree(String siteid, @Param(value="pid") String pid) {
        try {
            List list = this.cmsChannelService.query((Condition)Cnd.where((String)"siteid", (String)"=", (Object)siteid).asc("location").asc("path"));
            NutMap menuMap = NutMap.NEW();
            for (Cms_channel channel : list) {
                ArrayList<Cms_channel> list1 = menuMap.getList(channel.getParentId(), Cms_channel.class);
                if (list1 == null) {
                    list1 = new ArrayList<Cms_channel>();
                }
                list1.add(channel);
                menuMap.put((Object)channel.getParentId(), list1);
            }
            return Result.success().addData(this.getTree(menuMap, ""));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    private List<NutMap> getTree(NutMap menuMap, String pid) {
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        if (Strings.isBlank((CharSequence)pid)) {
            NutMap root = NutMap.NEW().addv("value", (Object)"root").addv("label", (Object)"\u6240\u6709\u680f\u76ee");
            treeList.add(root);
        }
        List subList = menuMap.getList(pid, Cms_channel.class);
        for (Cms_channel channel : subList) {
            NutMap map = Lang.obj2nutmap((Object)channel);
            map.put((Object)"label", (Object)channel.getName());
            if (channel.isHasChildren() || menuMap.get((Object)channel.getId()) != null) {
                map.put((Object)"children", this.getTree(menuMap, channel.getId()));
            }
            treeList.add(map);
        }
        return treeList;
    }

    @At(value={"/data/?"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"cms.content.article"})
    public Object data(String siteid, @Param(value="channelId") String channelId, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            cnd.and("siteid", "=", (Object)siteid);
            if (!Strings.isBlank((CharSequence)channelId) && !"root".equals(channelId)) {
                cnd.and("channelId", "=", (Object)channelId);
            }
            if (!Strings.isBlank((CharSequence)searchKeyword)) {
                cnd.and("title", "like", (Object)("%" + searchKeyword + "%"));
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.cmsArticleService.listPage(Integer.valueOf(pageNumber), pageSize, (Condition)cnd, "^(id|siteid|title|author|disabled|publishAt|endAt|location|view_num)$"));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/addDo/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article.add"})
    @SLog(tag="\u6dfb\u52a0\u6587\u7ae0", msg="\u6587\u7ae0\u6807\u9898:${args[1].title}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object addDo(String siteid, @Param(value="..") Cms_article article, @Param(value="time_param") long[] time, HttpServletRequest req) {
        try {
            article.setPublishAt(Long.valueOf(time[0] / 1000L));
            article.setEndAt(Long.valueOf(time[1] / 1000L));
            article.setSiteid(siteid);
            article.setStatus(0);
            article.setOpBy(StringUtil.getPlatformUid());
            this.cmsArticleService.insert((Object)article);
            this.cmsArticleService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article"})
    public Object edit(String id, HttpServletRequest req) {
        try {
            Cms_article article = (Cms_article)this.cmsArticleService.fetch(id);
            return Result.success().addData((Object)article);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article.edit"})
    @SLog(tag="\u4fee\u6539\u6587\u7ae0", msg="\u6587\u7ae0\u6807\u9898:${args[0].title}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object editDo(@Param(value="..") Cms_article article, @Param(value="time_param") long[] time, HttpServletRequest req) {
        try {
            article.setPublishAt(Long.valueOf(time[0] / 1000L));
            article.setEndAt(Long.valueOf(time[1] / 1000L));
            article.setStatus(0);
            article.setOpBy(StringUtil.getPlatformUid());
            this.cmsArticleService.updateIgnoreNull((Object)article);
            this.cmsArticleService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error();
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article.edit"})
    @SLog(tag="\u53d1\u5e03\u6587\u7ae0", msg="\u6587\u7ae0\u6807\u9898:${args[1].getAttribute('title')}")
    public Object enable(String id, HttpServletRequest req) {
        try {
            req.setAttribute("title", (Object)((Cms_article)this.cmsArticleService.fetch(id)).getTitle());
            this.cmsArticleService.update(Chain.make((String)"disabled", (Object)false).add("status", (Object)0), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            this.cmsArticleService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article.edit"})
    @SLog(tag="\u53d6\u6d88\u53d1\u5e03", msg="\u6587\u7ae0\u6807\u9898:${args[1].getAttribute('title')}")
    public Object disable(String id, HttpServletRequest req) {
        try {
            req.setAttribute("title", (Object)((Cms_article)this.cmsArticleService.fetch(id)).getTitle());
            this.cmsArticleService.update(Chain.make((String)"disabled", (Object)true).add("status", (Object)0), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            this.cmsArticleService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?", "/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.article.delete"})
    @SLog(tag="\u5220\u9664\u6587\u7ae0", msg="ID:${args[2].getAttribute('id')}")
    public Object delete(String oneId, @Param(value="ids") String[] ids, HttpServletRequest req) {
        try {
            if (ids != null && ids.length > 0) {
                this.cmsArticleService.delete(ids);
                req.setAttribute("id", (Object)StringUtils.toString((Object[])ids));
            } else {
                this.cmsArticleService.delete(oneId);
                req.setAttribute("id", (Object)oneId);
            }
            this.cmsArticleService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

