/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.services.SysLogService;
import cn.wizzer.app.web.commons.utils.DateUtil;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/log"})
public class SysLogController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysLogService sysLogService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/log/index.html")
    @RequiresPermissions(value={"sys.manager.log"})
    public void index(HttpServletRequest req) {
        req.setAttribute("today", (Object)DateUtil.getDate());
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.log"})
    public Object data(@Param(value="searchDate") String searchDate, @Param(value="searchType") String searchType, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            String[] date = StringUtils.split((String)searchDate, (String)",");
            return Result.success().addData((Object)this.sysLogService.data(date, searchType, pageOrderName, PageUtil.getOrder(pageOrderBy), pageNumber, pageSize));
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

