/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.ext.websocket;

import java.util.Set;
import org.nutz.integration.jedis.JedisAgent;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.mvc.websocket.WsRoomProvider;
import redis.clients.jedis.Jedis;

public class WkJedisRoomProvider
implements WsRoomProvider {
    private static final Log log = Logs.get();
    protected JedisAgent jedisAgent;

    public WkJedisRoomProvider(JedisAgent jedisAgent) {
        this.jedisAgent = jedisAgent;
    }

    public Set<String> wsids(String room) {
        try (Jedis jedis = this.jedisAgent.getResource();){
            Set set = jedis.smembers(room);
            return set;
        }
    }

    public void join(String room, String wsid) {
        try (Jedis jedis = this.jedisAgent.getResource();){
            jedis.sadd(room, new String[]{wsid});
            jedis.expire(room, 7200);
        }
    }

    public void left(String room, String wsid) {
        try (Jedis jedis = this.jedisAgent.getResource();){
            jedis.expire(room, 180);
        }
    }
}

