/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.base.Globals;
import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.utils.DateUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.io.File;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;
import org.nutz.weixin.bean.WxPayRedPack;
import org.nutz.weixin.bean.WxPayRedPackGroup;
import org.nutz.weixin.bean.WxPayTransfers;
import org.nutz.weixin.bean.WxPayUnifiedOrder;
import org.nutz.weixin.spi.WxApi2;

@IocBean
@At(value={"/platform/wx/conf/account/paytest"})
public class WxPayTestController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxConfigService wxConfigService;
    @Inject
    private WxService wxService;

    @At(value={""})
    @Ok(value="beetl:/platform/wx/pay/index.html")
    @RequiresAuthentication
    public void index() {
    }

    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object payWxpay(@Param(value="money") int money, HttpServletRequest req) {
        try {
            Wx_config config = (Wx_config)this.wxConfigService.fetch((Condition)Cnd.NEW().limit(1, 1));
            NutMap payinfo = (NutMap)Json.fromJson(NutMap.class, (CharSequence)config.getPayInfo());
            WxApi2 wxApi2 = this.wxService.getWxApi2(config.getId());
            WxPayUnifiedOrder order = new WxPayUnifiedOrder();
            order.setAppid(config.getAppid());
            order.setMch_id(payinfo.getString("wxpay_mchid"));
            order.setNonce_str(R.UU32());
            order.setBody("Test");
            order.setOut_trade_no(DateUtil.format(new Date(), "yyyyMMddHHmmss"));
            order.setTotal_fee(money);
            order.setSpbill_create_ip(Lang.getIP((HttpServletRequest)req));
            order.setNotify_url(Globals.AppDomain + "/open/pay/wx/back/sendNotify");
            order.setTrade_type("NATIVE");
            order.setProduct_id("Test");
            NutMap resp = wxApi2.pay_unifiedorder(payinfo.getString("wxpay_key"), order);
            String return_code = resp.getString("return_code", "");
            String code_url = resp.getString("code_url", "");
            log.debug((Object)("resp:::" + Json.toJson((Object)resp)));
            return Result.success((String)"system.success", (Object)code_url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object redpack(@Param(value="redpack") int redpack, @Param(value="openid") String openid, HttpServletRequest req) {
        try {
            Wx_config config = (Wx_config)this.wxConfigService.fetch((Condition)Cnd.NEW().limit(1, 1));
            NutMap payinfo = (NutMap)Json.fromJson(NutMap.class, (CharSequence)config.getPayInfo());
            WxApi2 wxApi2 = this.wxService.getWxApi2(config.getId());
            WxPayRedPack redPack = new WxPayRedPack();
            redPack.setNonce_str(R.UU32());
            redPack.setMch_billno(payinfo.getString("wxpay_mchid") + DateUtil.format(new Date(), "yyyyMMddHHmmss"));
            redPack.setMch_id(payinfo.getString("wxpay_mchid"));
            redPack.setWxappid(config.getAppid());
            redPack.setSend_name("\u5927\u9ca8\u9c7c");
            redPack.setRe_openid(openid);
            redPack.setTotal_amount(redpack);
            redPack.setTotal_num(1);
            redPack.setWishing("\u65b0\u5e74\u5feb\u4e50");
            redPack.setClient_ip(Lang.getIP((HttpServletRequest)req));
            redPack.setAct_name("\u626b\u7801\u5f97\u7ea2\u5305");
            redPack.setRemark("\u626b\u5f97\u8d8a\u591a\u5f97\u7684\u8d8a\u591a\uff01");
            redPack.setScene_id("PRODUCT_1");
            File file = new File(Globals.AppRoot + "/WEB-INF/cert/wxpay/" + config.getId() + ".p12");
            NutMap resp = wxApi2.send_redpack(payinfo.getString("wxpay_key"), redPack, file, payinfo.getString("wxpay_mchid"));
            log.debug((Object)("resp:::" + Json.toJson((Object)resp)));
            return Result.success((String)Json.toJson((Object)resp));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object redpackGroup(@Param(value="redpack") int redpack, @Param(value="openid") String openid, HttpServletRequest req) {
        try {
            Wx_config config = (Wx_config)this.wxConfigService.fetch((Condition)Cnd.NEW().limit(1, 1));
            NutMap payinfo = (NutMap)Json.fromJson(NutMap.class, (CharSequence)config.getPayInfo());
            WxApi2 wxApi2 = this.wxService.getWxApi2(config.getId());
            WxPayRedPackGroup redPack = new WxPayRedPackGroup();
            redPack.setNonce_str(R.UU32());
            redPack.setMch_billno(payinfo.getString("wxpay_mchid") + DateUtil.format(new Date(), "yyyyMMddHHmmss"));
            redPack.setMch_id(payinfo.getString("wxpay_mchid"));
            redPack.setWxappid(config.getAppid());
            redPack.setSend_name("\u5927\u9ca8\u9c7c\u7684\u88c2\u53d8");
            redPack.setRe_openid(openid);
            redPack.setTotal_amount(redpack);
            redPack.setTotal_num(3);
            redPack.setAmt_type("ALL_RAND");
            redPack.setWishing("\u65b0\u5e74\u5feb\u4e50");
            redPack.setAct_name("\u626b\u7801\u5f97\u7ea2\u5305");
            redPack.setRemark("\u626b\u5f97\u8d8a\u591a\u5f97\u7684\u8d8a\u591a\uff01");
            redPack.setScene_id("PRODUCT_1");
            File file = new File(Globals.AppRoot + "/WEB-INF/cert/wxpay/" + config.getId() + ".p12");
            NutMap resp = wxApi2.send_redpackgroup(payinfo.getString("wxpay_key"), redPack, file, payinfo.getString("wxpay_mchid"));
            log.debug((Object)("resp:::" + Json.toJson((Object)resp)));
            return Result.success((String)Json.toJson((Object)resp));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object transfers(@Param(value="redpack") int redpack, @Param(value="openid") String openid, HttpServletRequest req) {
        try {
            Wx_config config = (Wx_config)this.wxConfigService.fetch((Condition)Cnd.NEW().limit(1, 1));
            NutMap payinfo = (NutMap)Json.fromJson(NutMap.class, (CharSequence)config.getPayInfo());
            WxApi2 wxApi2 = this.wxService.getWxApi2(config.getId());
            WxPayTransfers wxPayTransfers = new WxPayTransfers();
            wxPayTransfers.setNonce_str(R.UU32());
            wxPayTransfers.setAmount(redpack);
            wxPayTransfers.setCheck_name("NO_CHECK");
            wxPayTransfers.setDesc("\u4ed8\u6b3e\u6d4b\u8bd5");
            wxPayTransfers.setMchid(payinfo.getString("wxpay_mchid"));
            wxPayTransfers.setMch_appid(config.getAppid());
            wxPayTransfers.setPartner_trade_no(payinfo.getString("wxpay_mchid") + DateUtil.format(new Date(), "yyyyMMddHHmmss"));
            wxPayTransfers.setOpenid(openid);
            wxPayTransfers.setSpbill_create_ip(Lang.getIP((HttpServletRequest)req));
            wxPayTransfers.setRe_user_name("\u5927\u9ca8\u9c7c");
            File file = new File(Globals.AppRoot + "/WEB-INF/cert/wxpay/" + config.getId() + ".p12");
            NutMap resp = wxApi2.pay_transfers(payinfo.getString("wxpay_key"), wxPayTransfers, file, payinfo.getString("wxpay_mchid"));
            log.debug((Object)("resp:::" + Json.toJson((Object)resp)));
            return Result.success((String)Json.toJson((Object)resp));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)"system.error");
        }
    }
}

