/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxTplLogService;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.util.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/wx/tpl/log"})
public class WxTplLogController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxTplLogService wxTplLogService;
    @Inject
    @Reference
    private WxConfigService wxConfigService;

    @At(value={"", "/index/?"})
    @Ok(value="beetl:/platform/wx/tpl/log/index.html")
    @RequiresPermissions(value={"wx.tpl.log"})
    public void index(String wxid, HttpServletRequest req) {
        Wx_config wxConfig = null;
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)list.get(0);
        }
        if (Strings.isNotBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)this.wxConfigService.fetch(wxid);
        }
        req.setAttribute("wxConfig", wxConfig);
        req.setAttribute("wxList", (Object)list);
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.tpl.log"})
    public Object data(@Param(value="wxid") String wxid, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        if (!Strings.isBlank((CharSequence)searchName) && !Strings.isBlank((CharSequence)searchKeyword)) {
            cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
        }
        if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData((Object)this.wxTplLogService.listPage(Integer.valueOf(pageNumber), pageSize, (Condition)cnd));
    }

    @At(value={"/delete/?", "/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.tpl.log"})
    @SLog(tag="\u5220\u9664\u6a21\u677f\u53d1\u9001\u65e5\u5fd7", msg="ID:${args[2].getAttribute('id')}")
    public Object delete(String oneId, @Param(value="ids") String[] ids, HttpServletRequest req) {
        try {
            if (ids != null && ids.length > 0) {
                this.wxTplLogService.delete(ids);
                req.setAttribute("id", (Object)StringUtils.toString((Object[])ids));
            } else {
                this.wxTplLogService.delete(oneId);
                req.setAttribute("id", (Object)oneId);
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

