/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.open.file;

import cn.wizzer.app.web.commons.base.Globals;
import cn.wizzer.app.web.commons.utils.DateUtil;
import cn.wizzer.framework.base.Result;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.nutz.boot.starter.ftp.FtpService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.impl.AdaptorErrorContext;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadAdaptor;

@IocBean
@At(value={"/open/file/upload"})
public class UploadController {
    private static final Log log = Logs.get();
    @Inject
    private FtpService ftpService;

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:fileUpload"})
    @POST
    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object file(@Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            String suffixName = tf.getSubmittedFileName().substring(tf.getSubmittedFileName().lastIndexOf(".")).toLowerCase();
            String filePath = Globals.AppUploadBase + "/file/" + DateUtil.format(new Date(), "yyyyMMdd") + "/";
            String fileName = R.UU32() + suffixName;
            String url = filePath + fileName;
            if (this.ftpService.upload(filePath, fileName, tf.getInputStream())) {
                return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("file_type", (Object)suffixName).addv("file_name", (Object)tf.getSubmittedFileName()).addv("file_size", (Object)tf.getSize()).addv("file_url", (Object)url));
            }
            return Result.error((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5ftp\u7528\u6237\u662f\u5426\u6709\u521b\u5efa\u76ee\u5f55\u6743\u9650");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            return Result.error((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
        }
    }

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:videoUpload"})
    @POST
    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object video(@Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            String suffixName = tf.getSubmittedFileName().substring(tf.getSubmittedFileName().lastIndexOf(".")).toLowerCase();
            String filePath = Globals.AppUploadBase + "/video/" + DateUtil.format(new Date(), "yyyyMMdd") + "/";
            String fileName = R.UU32() + suffixName;
            String url = filePath + fileName;
            if (this.ftpService.upload(filePath, fileName, tf.getInputStream())) {
                return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("file_type", (Object)suffixName).addv("file_name", (Object)tf.getSubmittedFileName()).addv("file_size", (Object)tf.getSize()).addv("file_url", (Object)url));
            }
            return Result.error((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5ftp\u7528\u6237\u662f\u5426\u6709\u521b\u5efa\u76ee\u5f55\u6743\u9650");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            return Result.error((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
        }
    }

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:imageUpload"})
    @POST
    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object image(@Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            String suffixName = tf.getSubmittedFileName().substring(tf.getSubmittedFileName().lastIndexOf(".")).toLowerCase();
            String filePath = Globals.AppUploadBase + "/image/" + DateUtil.format(new Date(), "yyyyMMdd") + "/";
            String fileName = R.UU32() + suffixName;
            String url = filePath + fileName;
            if (this.ftpService.upload(filePath, fileName, tf.getInputStream())) {
                return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)url);
            }
            return Result.error((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5ftp\u7528\u6237\u662f\u5426\u6709\u521b\u5efa\u76ee\u5f55\u6743\u9650");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            return Result.error((String)"\u56fe\u7247\u683c\u5f0f\u9519\u8bef");
        }
    }
}

