/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.cms.modules.services.impl;

import cn.wizzer.app.cms.modules.models.Cms_channel;
import cn.wizzer.app.cms.modules.services.CmsChannelService;
import cn.wizzer.framework.base.service.BaseServiceImpl;
import java.util.List;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.ioc.aop.Aop;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.plugins.wkcache.annotation.CacheDefaults;
import org.nutz.plugins.wkcache.annotation.CacheRemoveAll;
import org.nutz.plugins.wkcache.annotation.CacheResult;

@IocBean(args={"refer:dao"})
@CacheDefaults(cacheName="cms_channel")
public class CmsChannelServiceImpl
extends BaseServiceImpl<Cms_channel>
implements CmsChannelService {
    public CmsChannelServiceImpl(Dao dao) {
        super(dao);
    }

    @Override
    @Aop(value={"txREAD_COMMITTED"})
    public void save(Cms_channel channel, String pid) {
        String path = "";
        if (!Strings.isEmpty((CharSequence)pid)) {
            Cms_channel pp = (Cms_channel)this.fetch(pid);
            path = pp.getPath();
        } else {
            pid = "";
        }
        channel.setPath(this.getSubPath("cms_channel", "path", path));
        channel.setParentId(pid);
        this.dao().insert((Object)channel);
        if (!Strings.isEmpty((CharSequence)pid)) {
            this.update(Chain.make((String)"hasChildren", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)pid));
        }
    }

    @Override
    @Aop(value={"txREAD_COMMITTED"})
    public void deleteAndChild(Cms_channel channel) {
        int count;
        this.dao().execute(Sqls.create((String)"delete from cms_channel where path like @path").setParam("path", (Object)(channel.getPath() + "%")));
        this.dao().execute(Sqls.create((String)"delete from cms_article where channelId=@id or channelId in(SELECT id FROM cms_channel WHERE path like @path)").setParam("id", (Object)channel.getId()).setParam("path", (Object)(channel.getPath() + "%")));
        if (!Strings.isEmpty((CharSequence)channel.getParentId()) && (count = this.count((Condition)Cnd.where((String)"parentId", (String)"=", (Object)channel.getParentId()))) < 1) {
            this.dao().execute(Sqls.create((String)"update cms_channel set hasChildren=0 where id=@pid").setParam("pid", (Object)channel.getParentId()));
        }
    }

    @Override
    @CacheResult
    public Cms_channel getChannel(String id, String code) {
        if (Strings.isNotBlank((CharSequence)code)) {
            return (Cms_channel)this.fetch((Condition)Cnd.where((String)"code", (String)"=", (Object)code).and("disabled", "=", (Object)false));
        }
        return (Cms_channel)this.fetch(id);
    }

    @Override
    @CacheResult
    public boolean hasChannel(String code) {
        return this.count((Condition)Cnd.where((String)"code", (String)"=", (Object)code).and("disabled", "=", (Object)false)) > 0;
    }

    @Override
    @CacheResult
    public List<Cms_channel> listChannel(String parentId, String parentCode) {
        Cnd cnd = Cnd.NEW();
        if (Strings.isNotBlank((CharSequence)parentCode)) {
            Cms_channel channel = (Cms_channel)this.fetch((Condition)Cnd.where((String)"code", (String)"=", (Object)parentCode));
            if (channel != null) {
                cnd.and("parentId", "=", (Object)channel.getId()).and("disabled", "=", (Object)false);
            }
        } else {
            cnd.and("parentId", "=", (Object)Strings.sNull((Object)parentId)).and("disabled", "=", (Object)false);
        }
        cnd.asc("location");
        return this.query((Condition)cnd);
    }

    @Override
    @CacheRemoveAll
    public void clearCache() {
    }
}

